/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.config;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Configurations;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.ConfigurationModelValidator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

public class NamelessConfigTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private ExtensionModelValidator validator = new ConfigurationModelValidator();

    @Test
    public void useDefaultConfigurationNameOnceAnnotated() throws Exception {
        this.validate(OneConfigAnnotatedExtension.class);
    }

    @Test
    public void useDefaultConfigurationNameTwiceAnnotated() throws Exception {
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.expectedException.expectMessage("Configurations [config] were defined multiple times");
        this.validate(TwoConfigAnnotatedExtension.class);
    }

    @Test
    public void useDefaultConfigurationNameOnceNonAnnotated() throws Exception {
        this.validate(OneConfigNonAnnotatedExtension.class);
    }

    @Test
    public void useDefaultConfigurationNameTwiceNonAnnotated() throws Exception {
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.expectedException.expectMessage("Configurations [config] were defined multiple times");
        this.validate(TwoConfigNonAnnotatedExtension.class);
    }

    @Test
    public void useDefaultConfigurationNameMixedAnnotation() throws Exception {
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.expectedException.expectMessage("Configurations [config] were defined multiple times");
        this.validate(MixedConfigExtension.class);
    }

    private void validate(Class<?> connectorClass) {
        ExtensionsTestUtils.validate(connectorClass, (ExtensionModelValidator)this.validator);
    }

    public static class AnotherNonAnnotatedNamelessConfig {
    }

    public static class NonAnnotatedNamelessConfig {
    }

    @Configuration
    public static class AnotherAnnotatedNamelessConfig {
    }

    @Configuration
    public static class AnnotatedNamelessConfig {
    }

    @Extension(name="twice-mixed-annotated")
    @Configurations(value={AnnotatedNamelessConfig.class, NonAnnotatedNamelessConfig.class})
    public static class MixedConfigExtension {
    }

    @Extension(name="twice-non-annotated")
    @Configurations(value={NonAnnotatedNamelessConfig.class, AnotherNonAnnotatedNamelessConfig.class})
    public static class TwoConfigNonAnnotatedExtension {
    }

    @Extension(name="once-non-annotated")
    @Configurations(value={NonAnnotatedNamelessConfig.class})
    public static class OneConfigNonAnnotatedExtension {
    }

    @Extension(name="twice-annotated")
    @Configurations(value={AnnotatedNamelessConfig.class, AnotherAnnotatedNamelessConfig.class})
    public static class TwoConfigAnnotatedExtension {
    }

    @Extension(name="once-annotated")
    @Configurations(value={AnnotatedNamelessConfig.class})
    public static class OneConfigAnnotatedExtension {
    }
}

