/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.connector;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.matchers.ThrowableMessageMatcher;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.petstore.extension.Aquarium;
import org.mule.test.petstore.extension.ExclusiveCashier;
import org.mule.test.petstore.extension.ExclusivePetBreeder;
import org.mule.test.petstore.extension.PetStoreDeal;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=MockitoJUnitRunner.class)
public class PetStoreExclusiveParameterRequiredWithNullExpressionTestCase
extends AbstractExtensionFunctionalTestCase {
    private final String TEST_VALUE = "TEST";
    @Mock
    ConfigurationProperties configProperties;

    protected Map<String, Object> getStartUpRegistryObjects() {
        ((ConfigurationProperties)Mockito.doReturn(Optional.empty()).when((Object)this.configProperties)).resolveBooleanProperty(org.mockito.Matchers.anyString());
        return Collections.singletonMap("_muleConfigurationAttributesResolver", this.configProperties);
    }

    protected String getConfigFile() {
        return "petstore-exclusive-parameters-required-with-null-expression.xml";
    }

    @Test
    public void getBreederOperationFail() throws Exception {
        ((FlowRunner)this.flowRunner("getBreederOperation").withVariable("mammals", null)).runExpectingException(ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Required parameters need to be assigned with non null values")));
    }

    @Test
    public void getBreederOperationSuccess() throws Exception {
        ExclusivePetBreeder exclusivePetBreeder = (ExclusivePetBreeder)((FlowRunner)this.flowRunner("getBreederOperation").withVariable("mammals", (Object)"TEST")).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)exclusivePetBreeder.getunaliasedNammals(), (Matcher)Matchers.is((Object)"TEST"));
    }

    @Test
    public void getAquariumOperationFail() throws Exception {
        ((FlowRunner)this.flowRunner("getAquariumOperation").withVariable("frogName", null)).runExpectingException(ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Required parameters need to be assigned with non null values")));
    }

    @Test
    public void getAquariumOperationSuccess() throws Exception {
        Aquarium aquarium = (Aquarium)((FlowRunner)this.flowRunner("getAquariumOperation").withVariable("frogName", (Object)"TEST")).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)aquarium.getPond().getFrogName(), (Matcher)Matchers.is((Object)"TEST"));
    }

    @Test
    public void getCashierOperationSucess() throws Exception {
        ExclusiveCashier cashier = (ExclusiveCashier)((FlowRunner)this.flowRunner("getCashierOperation").withVariable("pensionPlan", null)).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)cashier.getDebt(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)cashier.getMoney(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)cashier.getPensionPlan(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)cashier.getRothIRA(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void getPetStoreDealOperation() throws Exception {
        PetStoreDeal petStoreDeal = (PetStoreDeal)((FlowRunner)this.flowRunner("getPetStoreDealOperation").withVariable("pensionPlan", null)).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)petStoreDeal.getCashier().getPensionPlan(), (Matcher)Matchers.nullValue());
    }
}

