/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.schema.builder;

import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModelVisitor;
import org.mule.runtime.api.meta.model.nested.NestedChainModel;
import org.mule.runtime.api.meta.model.nested.NestedComponentModel;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.config.internal.dsl.SchemaConstants;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.property.QNameModelProperty;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.internal.capability.xml.schema.builder.SchemaBuilder;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.Attribute;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ComplexContent;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ExplicitGroup;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ExtensionType;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.LocalComplexType;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.NamedGroup;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ObjectFactory;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.TopLevelComplexType;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.TopLevelElement;

abstract class ExecutableTypeSchemaDelegate {
    protected final SchemaBuilder builder;
    protected final ObjectFactory objectFactory = new ObjectFactory();
    private final Map<String, TopLevelElement> substitutionGroups = new LinkedHashMap<String, TopLevelElement>();
    private final DslSyntaxResolver dsl;

    ExecutableTypeSchemaDelegate(SchemaBuilder builder) {
        this.builder = builder;
        this.dsl = builder.getDslResolver();
    }

    protected ExtensionType createExecutableType(String name, QName base, DslElementSyntax dslSyntax, boolean hasImplicitConfig) {
        TopLevelComplexType complexType = new TopLevelComplexType();
        complexType.setName(name);
        ComplexContent complexContent = new ComplexContent();
        complexType.setComplexContent(complexContent);
        ExtensionType complexContentExtension = new ExtensionType();
        complexContentExtension.setBase(base);
        complexContent.setExtension(complexContentExtension);
        if (dslSyntax.requiresConfig()) {
            Attribute configAttr = this.builder.createAttribute("config-ref", "Specify which configuration to use for this invocation.", hasImplicitConfig, SchemaConstants.SUBSTITUTABLE_NAME);
            complexContentExtension.getAttributeOrAttributeGroup().add(configAttr);
        }
        this.builder.getSchema().getSimpleTypeOrComplexTypeOrGroup().add(complexType);
        return complexContentExtension;
    }

    protected void registerParameterGroup(ExtensionType type, ParameterGroupModel group) {
        if (group.isShowInDsl()) {
            this.builder.addInlineParameterGroup(group, type.getSequence());
        } else {
            this.registerParameters(type, group.getParameterModels());
        }
    }

    protected ExtensionType registerParameters(ExtensionType type, List<ParameterModel> parameterModels) {
        LinkedList<TopLevelElement> childElements = new LinkedList<TopLevelElement>();
        parameterModels.forEach(parameter -> {
            DslElementSyntax paramDsl = this.dsl.resolve(parameter);
            MetadataType parameterType = parameter.getType();
            boolean shouldDeclare = true;
            if (parameter.getModelProperty(QNameModelProperty.class).isPresent() && !parameter.getDslConfiguration().allowsReferences()) {
                shouldDeclare = false;
            }
            if (shouldDeclare) {
                this.builder.declareAsParameter(parameterType, type, (ParameterModel)parameter, paramDsl, (List<TopLevelElement>)childElements);
            }
        });
        this.appendToSequence(type, childElements);
        return type;
    }

    protected ExtensionType registerNestedComponents(final ExtensionType type, List<? extends NestableElementModel> nestedComponents) {
        this.initialiseSequence(type);
        nestedComponents.forEach(component -> component.accept(new NestableElementModelVisitor(){

            public void visit(NestedComponentModel component) {
            }

            public void visit(NestedChainModel component) {
                ExecutableTypeSchemaDelegate.this.generateNestedProcessorElement(type, component);
            }

            public void visit(NestedRouteModel component) {
                ExecutableTypeSchemaDelegate.this.generateNestedRouteElement(type, ExecutableTypeSchemaDelegate.this.dsl.resolve((NamedObject)component), component);
            }
        }));
        return type;
    }

    private void appendToSequence(ExtensionType type, List<TopLevelElement> childElements) {
        if (!childElements.isEmpty()) {
            this.initialiseSequence(type);
            this.builder.addParameterToSequence(childElements, type.getSequence());
        }
    }

    protected void initialiseSequence(ExtensionType type) {
        if (type.getSequence() == null) {
            ExplicitGroup sequence = new ExplicitGroup();
            sequence.setMinOccurs(BigInteger.ZERO);
            sequence.setMaxOccurs("1");
            type.setSequence(sequence);
        }
    }

    private void generateNestedRouteElement(ExtensionType type, DslElementSyntax routeDsl, NestedRouteModel routeModel) {
        NestedChainModel chain = (NestedChainModel)routeModel.getNestedComponents().get(0);
        LocalComplexType complexType = this.builder.getObjectSchemaDelegate().createTypeExtension(SchemaConstants.MULE_ABSTRACT_EXTENSION_TYPE);
        ExplicitGroup routeSequence = new ExplicitGroup();
        complexType.getComplexContent().getExtension().setSequence(routeSequence);
        this.generateNestedProcessorElement(complexType.getComplexContent().getExtension(), chain);
        this.registerParameters(complexType.getComplexContent().getExtension(), routeModel.getAllParameterModels());
        TopLevelElement routeElement = this.builder.createTopLevelElement(routeDsl.getElementName(), BigInteger.valueOf(routeModel.getMinOccurs()), "1");
        routeElement.setComplexType(complexType);
        type.getSequence().getParticle().add(this.objectFactory.createElement(routeElement));
        if (routeModel.getMinOccurs() > 0) {
            type.getSequence().setMinOccurs(BigInteger.ONE);
        }
    }

    private void generateNestedProcessorElement(ExtensionType type, NestedChainModel chainModel) {
        ExplicitGroup choice = new ExplicitGroup();
        choice.setMinOccurs(chainModel.isRequired() ? BigInteger.ONE : BigInteger.ZERO);
        choice.setMaxOccurs("unbounded");
        chainModel.getAllowedStereotypes().forEach(stereotype -> {
            if (stereotype.equals(MuleStereotypes.PROCESSOR)) {
                NamedGroup group = this.builder.createGroup(SchemaConstants.MULE_MESSAGE_PROCESSOR_TYPE, true);
                choice.getParticle().add(this.objectFactory.createGroup(group));
            } else {
                TopLevelElement localAbstractElementRef = this.builder.createRefElement(this.getSubstitutionGroup((StereotypeModel)stereotype), true);
                choice.getParticle().add(this.objectFactory.createElement(localAbstractElementRef));
            }
        });
        type.getSequence().getParticle().add(this.objectFactory.createChoice(choice));
        if (chainModel.isRequired()) {
            type.getSequence().setMinOccurs(BigInteger.ONE);
        }
    }

    protected QName getSubstitutionGroup(StereotypeModel stereotypeDefinition) {
        if (stereotypeDefinition.equals(MuleStereotypes.PROCESSOR)) {
            return SchemaConstants.MULE_ABSTRACT_OPERATOR;
        }
        if (stereotypeDefinition.equals(MuleStereotypes.SOURCE)) {
            return SchemaConstants.MULE_ABSTRACT_MESSAGE_SOURCE;
        }
        if (stereotypeDefinition.equals(MuleStereotypes.VALIDATOR)) {
            return SchemaConstants.MULE_ABSTRACT_VALIDATOR;
        }
        return new QName(this.builder.getSchema().getTargetNamespace(), this.registerExtensibleElement(stereotypeDefinition));
    }

    private String registerExtensibleElement(StereotypeModel stereotypeModel) {
        String name = NameUtils.hyphenize((String)stereotypeModel.getType()).toLowerCase();
        TopLevelElement group = this.substitutionGroups.get(name);
        if (group == null) {
            TopLevelElement element = new TopLevelElement();
            element.setName(name);
            element.setAbstract(true);
            stereotypeModel.getParent().ifPresent(parent -> element.setSubstitutionGroup(this.getSubstitutionGroup((StereotypeModel)parent)));
            this.builder.getSchema().getSimpleTypeOrComplexTypeOrGroup().add(element);
            this.substitutionGroups.put(name, element);
        }
        return name;
    }
}

