/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.scopes;

import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNot;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class ScopeExecutionTestCase
extends AbstractExtensionFunctionalTestCase {
    private static final String KILL_REASON = "I'm the one who knocks";
    @Inject
    private SchedulerService schedulerService;
    private Scheduler cpuLightScheduler;
    private Scheduler testScheduler;
    @Rule
    public SystemProperty maxRedelivery = new SystemProperty("killingReason", "I'm the one who knocks");
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    protected String[] getConfigFiles() {
        return new String[]{"scopes/heisenberg-scope-config.xml"};
    }

    protected boolean isDisposeContextPerClass() {
        return true;
    }

    @Before
    public void setUp() {
        this.cpuLightScheduler = this.schedulerService.cpuLightScheduler();
        this.testScheduler = this.schedulerService.customScheduler(SchedulerConfig.config().withName("SCOPE-TEST").withMaxConcurrentTasks(2 + Runtime.getRuntime().availableProcessors() * 2));
    }

    @After
    public void tearDown() {
        this.cpuLightScheduler.stop();
        this.testScheduler.stop();
    }

    @Test
    public void fieldParameterInjection() throws Exception {
        Integer value = (Integer)((FlowRunner)((FlowRunner)this.flowRunner("scopeField").withVariable("expected", (Object)0)).withVariable("newValue", (Object)1)).run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)1));
        value = (Integer)((FlowRunner)((FlowRunner)this.flowRunner("scopeField").withVariable("expected", (Object)1)).withVariable("newValue", (Object)5)).run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)5));
    }

    @Test
    public void verifyProcessorInitialise() throws Exception {
        this.runFlow("getChain").getMessage().getPayload().getValue();
        this.runFlow("getChain").getMessage().getPayload().getValue();
        this.runFlow("getChain").getMessage().getPayload().getValue();
        int value = (Integer)this.runFlow("getCounter").getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void verifySameProcessorInstance() throws Exception {
        Object getChainFirst = this.runFlow("getChain").getMessage().getPayload().getValue();
        Object getChainSecond = this.runFlow("getChain").getMessage().getPayload().getValue();
        Assert.assertThat((Object)getChainFirst, (Matcher)CoreMatchers.is((Matcher)IsNot.not((Matcher)CoreMatchers.sameInstance((Object)getChainSecond))));
        Object firstChain = ClassUtils.getFieldValue((Object)getChainFirst, (String)"chain", (boolean)false);
        Object secondChain = ClassUtils.getFieldValue((Object)getChainSecond, (String)"chain", (boolean)false);
        Assert.assertThat((Object)firstChain, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)secondChain)));
    }

    @Test
    public void alwaysFailsWrapperFailure() throws Exception {
        this.expectedException.expectCause(CoreMatchers.instanceOf(ConnectionException.class));
        this.expectedException.expectMessage("ON_ERROR_ERROR");
        this.runFlow("alwaysFailsWrapperFailure");
    }

    @Test
    public void alwaysFailsWrapperSuccess() throws Exception {
        this.expectedException.expectCause(CoreMatchers.instanceOf(ConnectionException.class));
        this.expectedException.expectMessage("ON_SUCCESS_ERROR");
        this.runFlow("alwaysFailsWrapperSuccess");
    }

    @Test
    public void exceptionOnCallbacksSuccess() throws Exception {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("ON_ERROR_EXCEPTION");
        this.runFlow("exceptionOnCallbacksSuccess");
    }

    @Test
    public void exceptionOnCallbacksFailure() throws Exception {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("ON_ERROR_EXCEPTION");
        this.runFlow("exceptionOnCallbacksFailure");
    }

    @Test
    public void anything() throws Exception {
        CoreEvent event = ((FlowRunner)this.flowRunner("executeAnything").withPayload((Object)"Killed the following because I'm the one who knocks:")).run();
        String expected = "Killed the following because I'm the one who knocks:";
        Assert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)expected));
    }

    @Test
    public void neverFailsWrapperFailingChain() throws Exception {
        CoreEvent event = this.flowRunner("neverFailsWrapperFailingChain").run();
        Assert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"ERROR"));
        Assert.assertThat((Object)((TypedValue)event.getVariables().get("varName")).getValue(), (Matcher)CoreMatchers.is((Object)"varValue"));
    }

    @Test
    public void neverFailsWrapperSuccessChain() throws Exception {
        CoreEvent event = ((FlowRunner)this.flowRunner("neverFailsWrapperSuccessChain").withVariable("newpayload", (Object)"newpayload2")).run();
        Assert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"SUCCESS"));
        Assert.assertThat((Object)((TypedValue)event.getVariables().get("varName")).getValue(), (Matcher)CoreMatchers.is((Object)"varValue"));
    }

    @Test
    public void payloadModifier() throws Exception {
        CoreEvent event = this.flowRunner("payloadModifier").run();
        Assert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"MESSAGE"));
        Assert.assertThat((Object)((TypedValue)event.getVariables().get("newPayload")).getValue(), (Matcher)CoreMatchers.is((Object)"MESSAGE"));
        Assert.assertThat((Object)((TypedValue)event.getVariables().get("newAttributes")).getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void neverFailsWrapperNoChain() throws Exception {
        CoreEvent event = this.flowRunner("neverFailsWrapperNoChain").run();
        Assert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"EMPTY"));
    }

    @Test
    public void scopeExecutionDoesntBlockThreads() throws Exception {
        this.testScheduler.submit(() -> ((FlowRunner)this.flowRunner("executeNonBlocking").withPayload((Object)"Test Message")).run());
        int threadsToCreate = Runtime.getRuntime().availableProcessors() * 2 - 1;
        for (int i = 0; i < threadsToCreate; ++i) {
            this.testScheduler.submit(() -> ((FlowRunner)this.flowRunner("executeNonBlocking").withPayload((Object)"Test Message")).run());
        }
        Thread.sleep(2000L);
        this.cpuLightScheduler.submit(() -> {}).get(5L, TimeUnit.SECONDS);
    }
}

