/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.internal;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.artifact.ArtifactCoordinates;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.test.module.extension.internal.ParameterizedExtensionModelTestCase;

public abstract class FileGenerationParameterizedExtensionModelTestCase
extends ParameterizedExtensionModelTestCase {
    @Parameterized.Parameter(value=0)
    public ExtensionModelLoader loader;
    @Parameterized.Parameter(value=2)
    public String expectedFilePath;
    @Parameterized.Parameter(value=3)
    public ArtifactCoordinates artifactCoordinates;
    @Parameterized.Parameter(value=4)
    public List<Class<? extends ExtensionModel>> dependencies;
    protected String expectedContent;
    protected DslResolvingContext dslResolvingContext;

    @Before
    public void setup() throws IOException {
        this.expectedContent = IOUtils.getResourceAsString((String)(this.getExpectedFilesDir() + this.expectedFilePath), ((Object)((Object)this)).getClass());
    }

    @Before
    public void createDslResolvingContext() throws IOException {
        this.dslResolvingContext = DslResolvingContext.getDefault((Set)ImmutableSet.copyOf(this.dependencies.stream().map(extModelDepClass -> FileGenerationParameterizedExtensionModelTestCase.loadExtension(extModelDepClass, this.loader, null, DslResolvingContext.nullDslResolvingContext())).toList()));
    }

    @Test
    public final void generate() throws Exception {
        String actual = this.doGenerate(this.doLoadExtension());
        try {
            this.assertEquals(this.expectedContent, actual);
        }
        catch (Throwable t) {
            if (this.shouldUpdateExpectedFilesOnError()) {
                File root = new File(IOUtils.getResourceAsUrl((String)(this.getExpectedFilesDir() + this.expectedFilePath), ((Object)((Object)this)).getClass()).toURI());
                root = root.getParentFile();
                while (!root.getName().equals("target")) {
                    root = root.getParentFile();
                }
                root = root.getParentFile();
                File testDir = new File(root, "src/test/resources/" + this.getExpectedFilesDir());
                File target = new File(testDir, this.expectedFilePath);
                Files.writeString(Paths.get(target.getAbsolutePath(), new String[0]), (CharSequence)actual, new OpenOption[0]);
                System.out.println(this.expectedFilePath + " fixed");
            }
            throw t;
        }
    }

    protected abstract ExtensionModel doLoadExtension();

    protected abstract String doGenerate(ExtensionModel var1) throws Exception;

    protected abstract void assertEquals(String var1, String var2) throws Exception;

    protected abstract String getExpectedFilesDir();

    protected boolean shouldUpdateExpectedFilesOnError() {
        return false;
    }
}

