/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.internal;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.function.TriFunction;
import org.junit.AfterClass;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.artifact.ArtifactCoordinates;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.extension.api.loader.ExtensionModelLoadingRequest;
import org.mule.runtime.manifest.api.MuleManifest;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaExtensionModelLoader;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=Parameterized.class)
public abstract class ParameterizedExtensionModelTestCase
extends AbstractMuleTestCase {
    protected static Map<String, ExtensionModel> EXTENSION_MODELS = new HashMap<String, ExtensionModel>();
    protected static final ExtensionModelLoader JAVA_LOADER = new DefaultJavaExtensionModelLoader();

    @AfterClass
    public static void cleanUp() {
        EXTENSION_MODELS = new HashMap<String, ExtensionModel>();
    }

    protected static ExtensionModel loadExtension(Class<?> clazz, ExtensionModelLoader loader, ArtifactCoordinates coordinates, DslResolvingContext dslResolvingContext) {
        SmallMap params = SmallMap.of((Object)"type", (Object)clazz.getName(), (Object)"version", (Object)MuleManifest.getMuleManifest().getProductVersion(), (Object)"COMPILATION_MODE", (Object)true);
        final String basePackage = clazz.getPackage().toString();
        ClassLoader pluginClassLoader = new ClassLoader(clazz.getClassLoader()){

            @Override
            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                if (name.startsWith(basePackage)) {
                    try {
                        byte[] classBytes = IOUtils.toByteArray((InputStream)this.getClass().getResourceAsStream("/" + name.replaceAll("\\.", "/") + ".class"));
                        return this.defineClass(null, classBytes, 0, classBytes.length);
                    }
                    catch (Exception e) {
                        return super.loadClass(name);
                    }
                }
                return super.loadClass(name, resolve);
            }
        };
        ExtensionModelLoadingRequest.Builder builder = ExtensionModelLoadingRequest.builder((ClassLoader)pluginClassLoader, (DslResolvingContext)dslResolvingContext).setResolveMinMuleVersion(true).addParameters((Map)params);
        if (coordinates != null) {
            builder.setArtifactCoordinates(coordinates);
        }
        return loader.loadExtensionModel(builder.build());
    }

    public static class ExtensionUnitTest {
        final ExtensionModelLoader loader;
        final Class<?> extensionClass;
        final ArtifactCoordinates artifactCoordinates;

        protected ExtensionUnitTest(ExtensionModelLoader loader, Class<?> extensionClass, ArtifactCoordinates artifactCoordinates) {
            this.loader = loader;
            this.extensionClass = extensionClass;
            this.artifactCoordinates = artifactCoordinates;
        }

        ExtensionModelLoader getLoader() {
            return this.loader;
        }

        Class<?> getExtensionClass() {
            return this.extensionClass;
        }

        ArtifactCoordinates getArtifactCoordinates() {
            return this.artifactCoordinates;
        }

        public final Object[] toTestParams(TriFunction<Class<?>, ExtensionModelLoader, ArtifactCoordinates, ExtensionModel> createExtensionModel) {
            ExtensionModel extensionModel = (ExtensionModel)createExtensionModel.apply(this.getExtensionClass(), (Object)this.getLoader(), (Object)this.getArtifactCoordinates());
            return this.buildTestParams(extensionModel);
        }

        protected Object[] buildTestParams(ExtensionModel extensionModel) {
            return new Object[]{extensionModel};
        }
    }
}

