/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.nb;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.functional.api.exception.ExpectedError;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.api.flow.TransactionConfigEnum;
import org.mule.functional.junit4.matchers.ThrowableMessageMatcher;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.tck.probe.PollingProber;
import org.mule.test.marvel.ironman.IronMan;
import org.mule.test.marvel.model.MissileProofVillain;
import org.mule.test.marvel.model.Villain;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

public class NonBlockingOperationsTestCase
extends AbstractExtensionFunctionalTestCase {
    @Rule
    public ExpectedError expectedException = ExpectedError.none();

    protected String getConfigFile() {
        return "iron-man-config.xml";
    }

    @Before
    public void setUp() {
        ThreadCaptor.setCapturedThreads(ConcurrentHashMap.newKeySet());
    }

    @After
    public void tearDown() {
        ThreadCaptor.setCapturedThreads(null);
    }

    @Test
    public void nonBlockingConnectedOperation() throws Exception {
        this.fireMissileAndAssert("fireMissile");
        this.assertCapturedThreadsNameMatch((Matcher<String>)Matchers.startsWith((String)"SimpleUnitTestSupportScheduler."));
    }

    @Test
    @Issue(value="MULE-18124")
    public void failingNonBlockingConnectedOperationThrownInsteadOfCallback() throws Exception {
        ((FlowRunner)this.flowRunner("fireMissileMishap").withPayload((Object)new Villain())).runExpectingException(ThrowableMessageMatcher.hasMessage((String)"Ultron jammed the missile system!"));
    }

    @Test
    public void failingNonBlockingConnectedOperation() throws Exception {
        MissileProofVillain villain = new MissileProofVillain();
        try {
            ((FlowRunner)this.flowRunner("fireMissile").withPayload((Object)villain)).run();
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)villain.isAlive(), (Matcher)CoreMatchers.is((Object)true));
            this.assertCapturedThreadsNameMatch((Matcher<String>)Matchers.startsWith((String)"SimpleUnitTestSupportScheduler."));
            this.expectedException.expectFailingComponent(CoreMatchers.is((Object)((Component)this.locator.find(Location.builder().globalName("fireMissile").addProcessorsPart().addIndexPart(0).addProcessorsPart().addIndexPart(0).build()).get())));
            this.expectedException.expectMessage(CoreMatchers.is((Object)"Missile proof"));
            this.expectedException.expectCause(CoreMatchers.instanceOf(UnsupportedOperationException.class));
            throw e;
        }
    }

    @Test
    @Issue(value="MULE-19537")
    @Description(value="Tests that when a transaction is active in a thread obtained through a custom scheduler, no thread switch takes place when an error occurs")
    public void failingNonBlockingConnectedOperationInsideTransaction() throws Exception {
        MissileProofVillain villain = new MissileProofVillain();
        Transaction transaction = this.createTransactionMock();
        try {
            ((FlowRunner)this.flowRunner("nonBlockingOperationFailureInsideTransaction").transactionally(TransactionConfigEnum.ACTION_ALWAYS_BEGIN, transaction).withPayload((Object)villain)).run();
        }
        catch (Exception e) {
            MatcherAssert.assertThat(ThreadCaptor.capturedThreads, (Matcher)Matchers.hasSize((int)1));
            this.assertCapturedThreadsNameMatch((Matcher<String>)CoreMatchers.not((Matcher)Matchers.startsWith((String)"SimpleUnitTestSupportScheduler.")));
            this.expectedException.expectMessage(CoreMatchers.is((Object)"Missile proof"));
            this.expectedException.expectCause(CoreMatchers.instanceOf(UnsupportedOperationException.class));
            throw e;
        }
        finally {
            TransactionCoordination.getInstance().unbindTransaction(transaction);
        }
    }

    @Test
    public void nonBlockingOperationReconnection() throws Exception {
        this.fireMissileAndAssert("warMachineFireMissile");
        IronMan warMachine = this.getIronMan("warMachine");
        MatcherAssert.assertThat((Object)warMachine.getMissilesFired(), (Matcher)CoreMatchers.is((Object)2));
        this.assertCapturedThreadsNameMatch((Matcher<String>)Matchers.startsWith((String)"SimpleUnitTestSupportScheduler."));
    }

    @Test
    public void voidNonBlockingOperation() throws Exception {
        IronMan ironMan = this.getIronMan("ironMan");
        String payload = "take me to the avengers tower";
        CoreEvent event = ((FlowRunner)this.flowRunner("computeFlightPlan").withPayload((Object)"take me to the avengers tower")).run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue().toString(), (Matcher)CoreMatchers.equalTo((Object)"take me to the avengers tower"));
        PollingProber.probe((long)1000L, (long)1000L, () -> "Go Straight".equals(ironMan.getFlightPlan()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IronMan getIronMan(String name) {
        CoreEvent initialiserEvent = null;
        try {
            initialiserEvent = MuleExtensionUtils.getInitialiserEvent((MuleContext)muleContext);
            IronMan ironMan = (IronMan)ExtensionsTestUtils.getConfigurationInstanceFromRegistry((String)name, (CoreEvent)initialiserEvent, (MuleContext)muleContext).getValue();
            return ironMan;
        }
        finally {
            if (initialiserEvent != null) {
                ((BaseEventContext)initialiserEvent.getContext()).success();
            }
        }
    }

    private void fireMissileAndAssert(String flowName) throws Exception {
        Villain villain = new Villain();
        String result = (String)((FlowRunner)this.flowRunner(flowName).withPayload((Object)villain)).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)villain.isAlive(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)"KABOOM!"));
    }

    private Transaction createTransactionMock() throws TransactionException {
        Transaction transaction = (Transaction)Mockito.mock(Transaction.class);
        ((Transaction)Mockito.doAnswer(invocationOnMock -> {
            TransactionCoordination.getInstance().bindTransaction(transaction);
            return null;
        }).when((Object)transaction)).begin();
        return transaction;
    }

    private void assertCapturedThreadsNameMatch(Matcher<String> matcher) {
        for (Thread thread : ThreadCaptor.getCapturedThreads()) {
            MatcherAssert.assertThat((Object)thread.getName(), matcher);
        }
    }

    public static class ThreadCaptor
    extends AbstractComponent
    implements Processor {
        private static Set<Thread> capturedThreads = new HashSet<Thread>();

        public CoreEvent process(CoreEvent event) throws MuleException {
            capturedThreads.add(Thread.currentThread());
            return event;
        }

        public static void setCapturedThreads(Set<Thread> capturedThreads) {
            ThreadCaptor.capturedThreads = capturedThreads;
        }

        public static Set<Thread> getCapturedThreads() {
            return capturedThreads;
        }
    }
}

