/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.notification;

import io.qameta.allure.Story;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.runtime.api.notification.ExtensionNotification;
import org.mule.runtime.api.notification.ExtensionNotificationListener;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.NotificationListenerRegistry;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.heisenberg.extension.model.PersonalInfo;
import org.mule.test.heisenberg.extension.model.SimpleKnockeableDoor;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class ExtensionNotificationsTestCase
extends AbstractExtensionFunctionalTestCase {
    public static final int POLL_DELAY_MILLIS = 300;
    public static final int FLOW_STOP_TIMEOUT = 2000;
    private static final String HEISENBERG = "Heisenberg".toUpperCase();
    private static final String NEW_BATCH = "NEW_BATCH";
    private static final String NEXT_BATCH = "NEXT_BATCH";
    private static final String BATCH_TERMINATED = "BATCH_TERMINATED";
    private static final String BATCH_DELIVERY_FAILED = "BATCH_DELIVERY_FAILED";
    private static final String BATCH_DELIVERED = "BATCH_DELIVERED";
    private static final String BATCH_FAILED = "BATCH_FAILED";
    private static final String KNOCKING_DOOR = "KNOCKING_DOOR";
    private static final String KNOCKED_DOOR = "KNOCKED_DOOR";
    private TestExtensionNotificationListener listener = null;
    @Inject
    private NotificationListenerRegistry notificationListenerRegistry;

    protected String getConfigFile() {
        return "notifications-config.xml";
    }

    @Test
    public void operationFiresNotificationsWithCustomData() throws Exception {
        Latch latch = new Latch();
        this.setUpListener(notification -> this.checkIfDone(latch, 2), false);
        String correlationId = this.flowRunner("operationNotification").run().getCorrelationId();
        MatcherAssert.assertThat((String)"Expected notifications not received.", (Object)latch.await(6000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)true));
        MultiMap<String, ExtensionNotification> notifications = this.listener.getNotifications();
        Set keys = notifications.keySet();
        MatcherAssert.assertThat((Object)keys, (Matcher)Matchers.hasItem((Object)KNOCKING_DOOR));
        MatcherAssert.assertThat((Object)keys, (Matcher)Matchers.hasItem((Object)KNOCKED_DOOR));
        ExtensionNotification knockingDoor = (ExtensionNotification)notifications.get((Object)KNOCKING_DOOR);
        MatcherAssert.assertThat((Object)knockingDoor, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)knockingDoor.getAction().getNamespace(), (Matcher)Matchers.is((Object)HEISENBERG));
        MatcherAssert.assertThat((Object)knockingDoor.getData().getValue(), (Matcher)Matchers.instanceOf(SimpleKnockeableDoor.class));
        MatcherAssert.assertThat((Object)((SimpleKnockeableDoor)knockingDoor.getData().getValue()).getSimpleName(), (Matcher)Matchers.is((Object)"Top Level Skyler @ 308 Negra Arroyo Lane"));
        MatcherAssert.assertThat((Object)knockingDoor.getEvent().getCorrelationId(), (Matcher)Matchers.is((Object)correlationId));
        ExtensionNotification knockedDoor = (ExtensionNotification)notifications.get((Object)KNOCKED_DOOR);
        MatcherAssert.assertThat((Object)knockedDoor, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)knockedDoor.getAction().getNamespace(), (Matcher)Matchers.is((Object)HEISENBERG));
        MatcherAssert.assertThat((Object)knockedDoor.getData().getValue(), (Matcher)Matchers.instanceOf(SimpleKnockeableDoor.class));
        MatcherAssert.assertThat((Object)((SimpleKnockeableDoor)knockedDoor.getData().getValue()).getSimpleName(), (Matcher)Matchers.is((Object)"Top Level Skyler @ 308 Negra Arroyo Lane"));
        MatcherAssert.assertThat((Object)knockedDoor.getEvent().getCorrelationId(), (Matcher)Matchers.is((Object)correlationId));
    }

    @Test
    public void sourceFiresNotificationsOnSuccess() throws Exception {
        Latch latch = new Latch();
        this.setUpListener(notification -> this.checkIfDone(latch, 4), false);
        Flow flow = (Flow)this.getFlowConstruct("sourceNotifications");
        flow.start();
        MatcherAssert.assertThat((String)"Expected notifications not received.", (Object)latch.await(6000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)true));
        MultiMap<String, ExtensionNotification> notifications = this.listener.getNotifications();
        Set keys = notifications.keySet();
        MatcherAssert.assertThat(keys, (Matcher)Matchers.hasItem((Object)NEW_BATCH));
        MatcherAssert.assertThat(keys, (Matcher)Matchers.hasItem((Object)NEXT_BATCH));
        MatcherAssert.assertThat(keys, (Matcher)Matchers.hasItem((Object)BATCH_DELIVERED));
        MatcherAssert.assertThat(keys, (Matcher)Matchers.hasItem((Object)BATCH_TERMINATED));
        ExtensionNotification newBatch = this.verifyNotificationAndValue((ExtensionNotification)notifications.get(NEW_BATCH), 1);
        String correlationId = newBatch.getEvent().getCorrelationId();
        ExtensionNotification nextBatch = this.verifyNotificationAndValue((ExtensionNotification)notifications.get(NEXT_BATCH), 1000000L);
        MatcherAssert.assertThat((Object)nextBatch.getEvent().getCorrelationId(), (Matcher)Matchers.is((Object)correlationId));
        ExtensionNotification batchRedelivered = this.verifyNotificationAndValue((ExtensionNotification)notifications.get(BATCH_DELIVERED), 100L);
        MatcherAssert.assertThat((Object)batchRedelivered.getEvent().getCorrelationId(), (Matcher)Matchers.is((Object)correlationId));
        ExtensionNotification batchTerminated = this.verifyNotificationAndValue((ExtensionNotification)notifications.get(BATCH_TERMINATED), 1);
        MatcherAssert.assertThat((Object)batchTerminated.getEvent().getCorrelationId(), (Matcher)Matchers.is((Object)correlationId));
        this.requestFlowToStopAndWait("sourceNotifications");
    }

    @Test
    public void sourceFiresNotificationsOnError() throws Exception {
        Latch latch = new Latch();
        this.setUpListener(notification -> this.checkIfDone(latch, 4), false);
        Flow flow = (Flow)this.getFlowConstruct("sourceNotificationsError");
        flow.start();
        MatcherAssert.assertThat((String)"Expected notifications not received", (Object)latch.await(6000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)true));
        MultiMap<String, ExtensionNotification> notifications = this.listener.getNotifications();
        Set keys = notifications.keySet();
        MatcherAssert.assertThat((Object)keys, (Matcher)Matchers.hasItem((Object)NEW_BATCH));
        MatcherAssert.assertThat((Object)keys, (Matcher)Matchers.hasItem((Object)NEXT_BATCH));
        MatcherAssert.assertThat((Object)keys, (Matcher)Matchers.hasItem((Object)BATCH_DELIVERY_FAILED));
        MatcherAssert.assertThat((Object)keys, (Matcher)Matchers.hasItem((Object)BATCH_TERMINATED));
        ExtensionNotification newBatch = this.verifyNotificationAndValue((ExtensionNotification)notifications.get((Object)NEW_BATCH), 1);
        String correlationId = newBatch.getEvent().getCorrelationId();
        ExtensionNotification nextBatch = this.verifyNotificationAndValue((ExtensionNotification)notifications.get((Object)NEXT_BATCH), 1000000L);
        MatcherAssert.assertThat((Object)nextBatch.getEvent().getCorrelationId(), (Matcher)Matchers.is((Object)correlationId));
        ExtensionNotification batchDeliveryFailed = (ExtensionNotification)notifications.get((Object)BATCH_DELIVERY_FAILED);
        MatcherAssert.assertThat((Object)batchDeliveryFailed, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)batchDeliveryFailed.getAction().getNamespace(), (Matcher)Matchers.is((Object)HEISENBERG));
        MatcherAssert.assertThat((Object)batchDeliveryFailed.getData().getValue(), (Matcher)Matchers.instanceOf(PersonalInfo.class));
        MatcherAssert.assertThat((Object)((PersonalInfo)batchDeliveryFailed.getData().getValue()).getAge(), (Matcher)Matchers.is((Object)27));
        MatcherAssert.assertThat((Object)batchDeliveryFailed.getEvent().getCorrelationId(), (Matcher)Matchers.is((Object)correlationId));
        ExtensionNotification batchTerminated = this.verifyNotificationAndValue((ExtensionNotification)notifications.get((Object)BATCH_TERMINATED), 1);
        MatcherAssert.assertThat((Object)batchTerminated.getEvent().getCorrelationId(), (Matcher)Matchers.is((Object)correlationId));
        this.requestFlowToStopAndWait("sourceNotificationsError");
    }

    @Test
    @Story(value="Backpressure")
    public void sourceFiresNotificationsOnBackPressure() throws Exception {
        Latch failed = new Latch();
        Reference batchFailed = new Reference();
        this.setUpListener(notification -> {
            if (BATCH_FAILED.equals(notification.getAction().getIdentifier())) {
                batchFailed.set(notification);
                failed.release();
            }
        }, true);
        this.requestFlowToStartAndWait("sourceNotificationsBackPressure");
        MatcherAssert.assertThat((String)"Batch failure notification not received.", (Object)failed.await(10000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)true));
        ExtensionNotification backPressureNotification = (ExtensionNotification)batchFailed.get();
        MatcherAssert.assertThat((Object)backPressureNotification, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        final String correlationId = backPressureNotification.getEvent().getCorrelationId();
        new PollingProber(10000L, 200L).check(new Probe(){

            public boolean isSatisfied() {
                return ExtensionNotificationsTestCase.this.listener.getNotifications().getAll((Object)ExtensionNotificationsTestCase.BATCH_FAILED).stream().anyMatch(n -> n.getEvent().getCorrelationId().equals(correlationId));
            }

            public String describeFailure() {
                return "Expected notifications not found.";
            }
        });
        this.requestFlowToStopAndWait("sourceNotificationsBackPressure");
        MultiMap<String, ExtensionNotification> notifications = this.listener.getNotifications();
        Set keys = notifications.keySet();
        MatcherAssert.assertThat((Object)keys, (Matcher)Matchers.hasItem((Object)NEW_BATCH));
        MatcherAssert.assertThat((Object)keys, (Matcher)Matchers.hasItem((Object)NEXT_BATCH));
        MatcherAssert.assertThat((Object)keys, (Matcher)Matchers.hasItem((Object)BATCH_FAILED));
        MatcherAssert.assertThat((Object)keys, (Matcher)Matchers.hasItem((Object)BATCH_TERMINATED));
        int batchNumber = (Integer)backPressureNotification.getData().getValue();
        this.verifyNotificationAndValue(backPressureNotification, batchNumber);
        this.verifyNotificationAndValue(this.getNotificationMatch(notifications, correlationId, BATCH_TERMINATED), batchNumber);
    }

    private void checkIfDone(Latch latch, int expectedKeys) {
        if (this.listener.getNotifications().keySet().size() == expectedKeys) {
            latch.release();
        }
    }

    private ExtensionNotification getNotificationMatch(MultiMap<String, ExtensionNotification> notifications, String correlation, String id) {
        return notifications.getAll((Object)id).stream().filter(n -> correlation.equals(n.getEvent().getCorrelationId())).findAny().orElse(null);
    }

    private <T> ExtensionNotification verifyNotificationAndValue(ExtensionNotification notification, T expected) {
        MatcherAssert.assertThat((Object)notification.getAction().getNamespace(), (Matcher)Matchers.is((Object)HEISENBERG));
        MatcherAssert.assertThat((Object)notification.getData().getValue(), (Matcher)Matchers.instanceOf(expected.getClass()));
        MatcherAssert.assertThat((Object)notification.getData().getValue(), (Matcher)Matchers.is(expected));
        return notification;
    }

    private void setUpListener(Consumer<ExtensionNotification> onNotification, boolean correlationOn) {
        this.listener = new TestExtensionNotificationListener(onNotification, correlationOn);
        this.notificationListenerRegistry.registerListener((NotificationListener)this.listener);
    }

    protected void requestFlowToStartAndWait(String flowName) throws Exception {
        this.startFlow(flowName);
        this.checkFlowIsStarted(flowName);
    }

    protected void startFlow(String flowName) throws Exception {
        Flow flow = (Flow)this.getFlowConstruct(flowName);
        flow.start();
    }

    protected void stopFlow(String flowName) throws Exception {
        Flow flow = (Flow)this.getFlowConstruct(flowName);
        flow.stop();
    }

    protected void requestFlowToStopAndWait(String flowName) throws Exception {
        this.stopFlow(flowName);
        this.checkFlowIsStopped(flowName);
    }

    protected void checkFlowIsStopped(String flowName) throws Exception {
        Flow flow = (Flow)this.getFlowConstruct(flowName);
        new PollingProber(2000L, 300L).check((Probe)new JUnitLambdaProbe(() -> flow.getLifecycleState().isStopped(), "The flow did not stop in a reasonable amount of time"));
    }

    private void checkFlowIsStarted(String flowName) throws Exception {
        Flow flow = (Flow)this.getFlowConstruct(flowName);
        new PollingProber(2000L, 300L).check((Probe)new JUnitLambdaProbe(() -> flow.getLifecycleState().isStarted(), "The flow did not start in a reasonable amount of time"));
    }

    private class TestExtensionNotificationListener
    implements ExtensionNotificationListener {
        private final Consumer<ExtensionNotification> onNotification;
        private final MultiMap<String, ExtensionNotification> notifications = new MultiMap();
        private Map<String, Integer> correlationCount;

        public TestExtensionNotificationListener(Consumer<ExtensionNotification> onNotification, boolean correlationOn) {
            this.onNotification = onNotification;
            if (correlationOn) {
                this.correlationCount = new HashMap<String, Integer>();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNotification(ExtensionNotification notification) {
            Object object = this.notifications;
            synchronized (object) {
                this.notifications.put((Object)notification.getAction().getIdentifier(), (Object)notification);
            }
            if (this.correlationCount != null) {
                object = this.correlationCount;
                synchronized (object) {
                    String correlationId = notification.getEvent().getCorrelationId();
                    this.correlationCount.put(correlationId, this.correlationCount.computeIfAbsent(correlationId, correlation -> 0) + 1);
                }
            }
            this.onNotification.accept(notification);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MultiMap<String, ExtensionNotification> getNotifications() {
            MultiMap<String, ExtensionNotification> multiMap = this.notifications;
            synchronized (multiMap) {
                return this.notifications.toImmutableMultiMap();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized Integer getCorrelationCount(String correlationId) {
            Map<String, Integer> map = this.correlationCount;
            synchronized (map) {
                return this.correlationCount.get(correlationId);
            }
        }
    }
}

