/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.parameter.value;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.tck.probe.PollingProber;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.some.extension.ParameterGroupConfig;

@Feature(value="Java SDK")
@Story(value="Parameters definitions in Java SDK")
public class ParameterValueResolverTestCase
extends AbstractExtensionFunctionalTestCase {
    private static final int TIMEOUT = 5000;
    private static final int DELAY = 1000;
    private static final List<CoreEvent> EVENTS = new LinkedList<CoreEvent>();
    private static final ZonedDateTime ZONED_DATE_TIME_ON_CONFIG = ZonedDateTime.parse("2021-04-27T15:30Z");
    private static final ZonedDateTime ZONED_DATE_TIME_ON_SOURCE = ZonedDateTime.of(LocalDateTime.parse("2021-04-27T12:00"), ZoneId.of("America/Argentina/Buenos_Aires"));
    private static final ZonedDateTime ZONED_DATE_TIME_ON_OPERATION = ZonedDateTime.of(LocalDateTime.parse("2021-04-28T19:30:35"), ZoneOffset.of("+03:00"));

    protected void doTearDown() throws Exception {
        EVENTS.clear();
    }

    protected String getConfigFile() {
        return "parameter/parameter-value-resolver.xml";
    }

    @Test
    public void configurationWithZonedDateTimeParameter() throws Exception {
        ParameterGroupConfig configuration = (ParameterGroupConfig)this.getPayload("configurationWithZonedDateTimeParameter");
        boolean isEqual = ZONED_DATE_TIME_ON_CONFIG.isEqual(configuration.getZonedDateTime());
        MatcherAssert.assertThat((Object)isEqual, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void sourceWithZonedDateTimeParameter() throws Exception {
        this.startFlow("sourceWithZonedDateTimeParameter");
        this.assertEventsFired();
        boolean isEqual = ZONED_DATE_TIME_ON_SOURCE.isEqual((ZonedDateTime)EVENTS.get(0).getMessage().getPayload().getValue());
        MatcherAssert.assertThat((Object)isEqual, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void operationWithZonedDateTimeParameter() throws Exception {
        ZonedDateTime zonedDateTime = (ZonedDateTime)this.getPayload("operationWithZonedDateTimeParameter");
        boolean isEqual = ZONED_DATE_TIME_ON_OPERATION.isEqual(zonedDateTime);
        MatcherAssert.assertThat((Object)isEqual, (Matcher)Matchers.is((Object)true));
    }

    private void startFlow(String flowName) throws Exception {
        ((Startable)this.getFlowConstruct(flowName)).start();
    }

    private void assertEventsFired() {
        PollingProber.check((long)5000L, (long)1000L, () -> {
            List<CoreEvent> list = EVENTS;
            synchronized (list) {
                return EVENTS.size() >= 1;
            }
        });
    }

    private <T> T getPayload(String flowName) throws Exception {
        return (T)this.flowRunner(flowName).run().getMessage().getPayload().getValue();
    }

    public static class CaptureProcessor
    implements Processor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CoreEvent process(CoreEvent event) throws MuleException {
            List<CoreEvent> list = EVENTS;
            synchronized (list) {
                EVENTS.add(event);
            }
            return event;
        }
    }
}

