/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.inject;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.nio.charset.Charset;
import javax.inject.Inject;
import javax.inject.Named;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

@Feature(value="Java SDK")
@Story(value="javax.inject compatibility")
public class JavaxInjectCompatibilityTestCase
extends AbstractExtensionFunctionalTestCase {
    private static String storedData;
    @Inject
    @Named(value="source")
    private Flow sourceFlow;
    @Inject
    @Named(value="sourceConfig")
    private Flow sourceConfigFlow;

    protected String getConfigFile() {
        return "inject/javax-inject-compatibility-config.xml";
    }

    @Test
    public void sourceConfig() throws MuleException {
        this.sourceConfigFlow.start();
        new PollingProber().check((Probe)new JUnitLambdaProbe(() -> {
            MatcherAssert.assertThat((Object)storedData, (Matcher)Is.is((Object)Charset.defaultCharset().name()));
            return true;
        }));
    }

    @Test
    public void config() throws Exception {
        Message flowOutput = this.flowRunner("operationConfig").run().getMessage();
        MatcherAssert.assertThat((Object)flowOutput.getPayload().getValue(), (Matcher)Is.is((Object)Charset.defaultCharset().name()));
    }

    @Test
    public void connectionProvider() throws Exception {
        Message flowOutput = this.flowRunner("operationConnection").run().getMessage();
        MatcherAssert.assertThat((Object)flowOutput.getPayload().getValue(), (Matcher)Is.is((Object)Charset.defaultCharset().name()));
    }

    @Test
    public void source() throws MuleException {
        this.sourceFlow.start();
        new PollingProber().check((Probe)new JUnitLambdaProbe(() -> {
            MatcherAssert.assertThat((Object)storedData, (Matcher)Is.is((Object)Charset.defaultCharset().name()));
            return true;
        }));
    }

    @Test
    public void operation() throws Exception {
        Message flowOutput = this.flowRunner("operation").run().getMessage();
        MatcherAssert.assertThat((Object)flowOutput.getPayload().getValue(), (Matcher)Is.is((Object)Charset.defaultCharset().name()));
    }

    @Test
    public void pojo() throws Exception {
        Message flowOutput = this.flowRunner("operationPojo").run().getMessage();
        MatcherAssert.assertThat((Object)flowOutput.getPayload().getValue(), (Matcher)Is.is((Object)Charset.defaultCharset().name()));
    }

    @Test
    public void function() throws Exception {
        Message flowOutput = this.flowRunner("function").run().getMessage();
        MatcherAssert.assertThat((Object)flowOutput.getPayload().getValue(), (Matcher)Is.is((Object)Charset.defaultCharset().name()));
    }

    public static String storeData(String data) {
        storedData = data;
        return data;
    }
}

