/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.data.sample;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.StringContains;
import org.junit.Assert;
import org.junit.Before;
import org.mule.functional.junit4.AbstractArtifactAstTestCase;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.api.sampledata.SampleDataFailure;
import org.mule.runtime.api.sampledata.SampleDataResult;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.module.extension.api.runtime.config.ConfigurationProviderFactory;
import org.mule.runtime.module.extension.api.runtime.config.ExtensionDesignTimeResolversFactory;
import org.mule.runtime.module.extension.internal.runtime.config.DefaultConfigurationProviderFactory;
import org.mule.runtime.module.extension.internal.runtime.config.DefaultExtensionDesignTimeResolversFactory;
import org.mule.sdk.api.data.sample.SampleDataException;
import org.mule.test.data.sample.extension.SampleDataExtension;
import org.mule.test.module.extension.data.sample.SampleDataExecutor;

public abstract class AbstractSampleDataTestCase
extends AbstractArtifactAstTestCase {
    protected static final String EXPECTED_PAYLOAD = "my payload";
    protected static final String EXPECTED_ATTRIBUTES = "my attributes";
    protected static final String CONF_PREFIX = "from-conf-";
    protected static final String NULL_VALUE = "<<null>>";
    private ExtensionModel sampleDataExtension;
    private ExtensionDesignTimeResolversFactory extensionDesignTimeResolversFactory;
    private ConfigurationProviderFactory configurationProviderFactory;
    private SampleDataExecutor sampleDataExecutor;

    @Before
    public void createExtensionDesignTimeResolversFactory() throws InitialisationException {
        this.extensionDesignTimeResolversFactory = new DefaultExtensionDesignTimeResolversFactory();
        LifecycleUtils.initialiseIfNeeded((Object)this.extensionDesignTimeResolversFactory, (boolean)true, (MuleContext)muleContext);
        this.configurationProviderFactory = new DefaultConfigurationProviderFactory();
        LifecycleUtils.initialiseIfNeeded((Object)this.configurationProviderFactory, (boolean)true, (MuleContext)muleContext);
        this.sampleDataExecutor = new SampleDataExecutor(this.extensionDesignTimeResolversFactory);
    }

    protected Set<ExtensionModel> getRequiredExtensions() {
        HashSet<ExtensionModel> extensions = new HashSet<ExtensionModel>();
        extensions.add(MuleExtensionModelProvider.getExtensionModel());
        this.sampleDataExtension = this.loadExtension(SampleDataExtension.class, Collections.emptySet());
        extensions.add(this.sampleDataExtension);
        return extensions;
    }

    protected void assertMessage(SampleDataResult result, String payload, String attributes) {
        if (result.getSampleData().isPresent()) {
            this.assertMessage((Message)result.getSampleData().orElseThrow(), payload, attributes);
        } else {
            Assert.fail((String)((SampleDataFailure)result.getFailure().orElseThrow()).getReason());
        }
    }

    protected void assertMessage(Message message, String payload, String attributes) {
        MatcherAssert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)payload));
        MatcherAssert.assertThat((Object)message.getPayload().getDataType().getMediaType().matches(MediaType.APPLICATION_JSON), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)message.getAttributes().getValue(), (Matcher)CoreMatchers.equalTo((Object)attributes));
        MatcherAssert.assertThat((Object)message.getAttributes().getDataType().getMediaType().matches(MediaType.APPLICATION_XML), (Matcher)CoreMatchers.is((Object)true));
    }

    protected void assertError(SampleDataResult result, String failureCode, String errorMessage) {
        SampleDataFailure failure = (SampleDataFailure)result.getFailure().orElseThrow();
        MatcherAssert.assertThat((Object)failure.getFailureCode(), (Matcher)CoreMatchers.equalTo((Object)failureCode));
        MatcherAssert.assertThat((Object)failure.getMessage(), (Matcher)CoreMatchers.equalTo((Object)errorMessage));
    }

    protected void assertError(SampleDataResult result, String failureCode, String errorMessage, Class<? extends Exception> expectedCause) {
        SampleDataFailure failure = (SampleDataFailure)result.getFailure().orElseThrow();
        MatcherAssert.assertThat((Object)failure.getFailureCode(), (Matcher)CoreMatchers.equalTo((Object)failureCode));
        MatcherAssert.assertThat((Object)failure.getMessage(), (Matcher)CoreMatchers.equalTo((Object)errorMessage));
        MatcherAssert.assertThat((Object)failure.getReason(), (Matcher)StringContains.containsString((String)(System.lineSeparator() + "Caused by: " + expectedCause.getName() + ": ")));
    }

    protected SampleDataResult getOperationSampleByLocation(String flowName) throws SampleDataException {
        ComponentAst operationAst = this.getFlowComponent(flowName, TypedComponentIdentifier.ComponentType.OPERATION);
        Optional<ConfigurationProvider> configurationProvider = this.configNameFromComponent(operationAst).map(this::createConfigurationProvider);
        return this.sampleDataExecutor.getSampleData(operationAst.getExtensionModel(), MuleAstUtils.createComponentParameterizationFromComponentAst((ComponentAst)operationAst), configurationProvider);
    }

    protected SampleDataResult getSourceSampleByLocation(String flowName) throws SampleDataException {
        ComponentAst sourceAst = this.getFlowComponent(flowName, TypedComponentIdentifier.ComponentType.SOURCE);
        Optional<ConfigurationProvider> configurationProvider = this.configNameFromComponent(sourceAst).map(this::createConfigurationProvider);
        return this.sampleDataExecutor.getSampleData(sourceAst.getExtensionModel(), MuleAstUtils.createComponentParameterizationFromComponentAst((ComponentAst)sourceAst), configurationProvider);
    }

    protected SampleDataResult getSampleByComponentName(String componentName, Map<String, Object> parameters, String configName) throws SampleDataException {
        ComponentModel componentModel = (ComponentModel)this.sampleDataExtension.findComponentModel(componentName).orElseThrow();
        ComponentParameterization.Builder builder = ComponentParameterization.builder((ParameterizedModel)componentModel);
        parameters.entrySet().stream().forEach(e -> builder.withParameter((String)e.getKey(), e.getValue()));
        Optional<ConfigurationProvider> configurationProvider = Optional.empty();
        if (configName != null) {
            configurationProvider = Optional.of(this.createConfigurationProvider(configName));
        }
        return this.sampleDataExecutor.getSampleData(this.sampleDataExtension, builder.build(), configurationProvider);
    }

    private ConfigurationProvider createConfigurationProvider(String configName) {
        ComponentAst configAst = this.getTopLevelComponent(configName);
        ComponentParameterization configParameterization = MuleAstUtils.createComponentParameterizationFromComponentAst((ComponentAst)configAst);
        return this.extensionDesignTimeResolversFactory.createConfigurationProvider(this.sampleDataExtension, (ConfigurationModel)configParameterization.getModel(), configName, configParameterization.getParameters().entrySet().stream().collect(Collectors.toMap(e -> ((ParameterModel)((Pair)e.getKey()).getSecond()).getName(), Map.Entry::getValue)), Optional.empty(), Optional.empty(), this.configurationProviderFactory, null, null, SampleDataExecutor.getClassLoader(this.sampleDataExtension));
    }

    protected Map<String, Object> getDefaultParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("payload", EXPECTED_PAYLOAD);
        params.put("attributes", EXPECTED_ATTRIBUTES);
        return params;
    }

    protected Map<String, Object> getGroupParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("groupParameter", EXPECTED_PAYLOAD);
        params.put("optionalParameter", EXPECTED_ATTRIBUTES);
        return params;
    }
}

