/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.source;

import io.qameta.allure.Feature;
import io.qameta.allure.Stories;
import io.qameta.allure.Story;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.number.OrderingComparison;
import org.junit.ClassRule;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.probe.PollingProber;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

@Feature(value="Sources")
@Stories(value={@Story(value="Polling"), @Story(value="Watermark")})
public class PollingSourceLimitingTestCase
extends AbstractExtensionFunctionalTestCase {
    @ClassRule
    public static SystemProperty disableCacheComponentBuildingDefinitionRegistry = new SystemProperty("mule..functionalTest.cacheComponentBuildingDefinitionRegistry.disableOverride", "true");
    private static int PROBER_TIMEOUT = 10000;
    private static int CHECK_NOT_PROBER_TIMEOUT = 2000;
    private static int PROBER_FREQUENCY = 500;
    private static int NUMBER_OF_PETS = 7;
    private static MultiMap<Integer, String> ADOPTIONS = new MultiMap();

    protected void doTearDown() throws Exception {
        ADOPTIONS.clear();
    }

    protected boolean mustRegenerateExtensionModels() {
        return true;
    }

    protected Map<String, Object> getExtensionLoaderContextAdditionalParameters() {
        return Collections.singletonMap("EXTENSION_LOADER_ENABLE_POLLING_SOURCE_LIMIT", true);
    }

    protected Map<String, String> artifactProperties() {
        return Collections.singletonMap("EXTENSION_LOADER_ENABLE_POLLING_SOURCE_LIMIT", "true");
    }

    protected String getConfigFile() {
        return "source/polling-source-limiting-config.xml";
    }

    @Test
    public void noLimit() throws Exception {
        this.startFlow("noLimit");
        this.waitForAllPetsToBeAdopted();
        this.checkNoMorePetsAdopted();
        this.assertLimitIsApplied(Integer.MAX_VALUE);
    }

    @Test
    public void limitOne() throws Exception {
        this.startFlow("limitOne");
        this.waitForAllPetsToBeAdopted();
        this.checkNoMorePetsAdopted();
        this.assertLimitIsApplied(1);
    }

    @Test
    public void limitThree() throws Exception {
        this.startFlow("limitThree");
        this.waitForAllPetsToBeAdopted();
        this.checkNoMorePetsAdopted();
        this.assertLimitIsApplied(3);
    }

    @Test
    public void ascendingWatermark() throws Exception {
        this.startFlow("ascendingWatermark");
        this.waitForAllPetsToBeAdopted();
        this.checkNoMorePetsAdopted();
    }

    @Test
    public void descendingWatermark() throws Exception {
        this.startFlow("descendingWatermark");
        this.waitForAllPetsToBeAdopted();
        this.checkNoMorePetsAdopted();
    }

    @Test
    public void mixedWatermark() throws Exception {
        this.startFlow("mixedWatermark");
        this.waitForAllPetsToBeAdopted();
        this.checkNoMorePetsAdopted();
    }

    private void waitForAllPetsToBeAdopted() {
        PollingProber.check((long)PROBER_TIMEOUT, (long)PROBER_FREQUENCY, () -> ADOPTIONS.size() == NUMBER_OF_PETS);
    }

    private void startFlow(String flowName) throws Exception {
        ((Startable)this.getFlowConstruct(flowName)).start();
    }

    private void assertLimitIsApplied(int limit) {
        int adoptionPolls = ADOPTIONS.keySet().size();
        for (int i = 0; i < adoptionPolls - 1; ++i) {
            MatcherAssert.assertThat((Object)ADOPTIONS.getAll((Object)i), (Matcher)Matchers.hasSize((int)limit));
        }
        MatcherAssert.assertThat((Object)ADOPTIONS.getAll((Object)(adoptionPolls - 1)), (Matcher)Matchers.hasSize((Matcher)OrderingComparison.lessThanOrEqualTo((Comparable)Integer.valueOf(limit))));
    }

    private void checkNoMorePetsAdopted() {
        PollingProber.checkNot((long)CHECK_NOT_PROBER_TIMEOUT, (long)PROBER_FREQUENCY, () -> ADOPTIONS.size() > NUMBER_OF_PETS);
    }

    public static class AdoptionProcessor
    implements Processor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CoreEvent process(CoreEvent event) throws MuleException {
            String pet = (String)event.getMessage().getPayload().getValue();
            Integer poll = (Integer)event.getMessage().getAttributes().getValue();
            MultiMap<Integer, String> multiMap = ADOPTIONS;
            synchronized (multiMap) {
                ADOPTIONS.put((Object)poll, (Object)pet);
            }
            return event;
        }
    }
}

