/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.parameter.resolver;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.tck.probe.PollingProber;
import org.mule.test.heisenberg.extension.HeisenbergSourceAllOptionalCallbacks;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

@Features(value={@Feature(value="Java SDK"), @Feature(value="Sources")})
@Story(value="Parameters definitions in Java SDK")
public class CollidingSourceCallbackParametersTestCase
extends AbstractExtensionFunctionalTestCase {
    @Inject
    @Named(value="sourceCallbackError")
    private Flow sourceCallbackError;

    protected String getConfigFile() {
        return "parameter/colliding-source-callback-parameters.xml";
    }

    @Test
    @Issue(value="MULE-19621")
    @Description(value="The error callback is populated with default values when not present in the DSL, instead of being populated with the values form the source callback.")
    public void defaultErrorCallbackProperlyPopulated() throws MuleException {
        this.sourceCallbackError.start();
        PollingProber.probe(() -> HeisenbergSourceAllOptionalCallbacks.executedOnError);
        MatcherAssert.assertThat((Object)HeisenbergSourceAllOptionalCallbacks.receivedInlineOnErrorData.getAge(), (Matcher)Is.is((Object)Integer.parseInt("50")));
        MatcherAssert.assertThat((Object)HeisenbergSourceAllOptionalCallbacks.receivedInlineOnErrorData.getKnownAddresses(), (Matcher)Is.is((Matcher)Matchers.nullValue()));
    }
}

