/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.config;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.junit4.matchers.ThrowableMessageMatcher;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class StereotypedInternalReferenceTestCase
extends AbstractExtensionFunctionalTestCase {
    protected String getConfigFile() {
        return "stereotype-config-reference.xml";
    }

    @Test
    public void softReferencesAreResolvedOnlyAtRuntimeWithoutException() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("matchingOperationFlow");
        flow.start();
    }

    @Test
    public void flowReferenceWithoutException() throws Exception {
        this.flowRunner("referencedFlow").run().getMessage().getPayload();
    }

    @Test
    public void softReferencesFailsAtRuntime() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("operationMismatch");
        Exception thrown = (Exception)Assert.assertThrows(Exception.class, () -> flow.start());
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)CoreMatchers.containsString((String)"does not match the expected operation"));
    }

    @Test
    public void invalidFlowReference() throws Exception {
        this.flowRunner("nonReferencedFlow").runExpectingException(ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"referenced flow does not exist")));
    }
}

