/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.data.sample;

import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import io.qameta.allure.Story;
import org.junit.Test;
import org.mule.test.module.extension.data.sample.AbstractSampleDataTestCase;

@Features(value={@Feature(value="Sources"), @Feature(value="SDK Tooling Support")})
@Story(value="Metadata Service")
public class SourcesSampleDataByLocationTestCase
extends AbstractSampleDataTestCase {
    protected String getConfigFile() {
        return "data/sample/source-sample-data.xml";
    }

    @Test
    public void connectionLess() throws Exception {
        this.assertMessage(this.getSourceSampleByLocation("connectionLess"), "my payload", "my attributes");
    }

    @Test
    public void useConnection() throws Exception {
        this.assertMessage(this.getSourceSampleByLocation("useConnection"), "my payload", "my attributes");
    }

    @Test
    public void useConfig() throws Exception {
        this.assertMessage(this.getSourceSampleByLocation("useConfig"), "from-conf-my payload", "from-conf-my attributes");
    }

    @Test
    public void parameterGroup() throws Exception {
        this.assertMessage(this.getSourceSampleByLocation("parameterGroup"), "my payload", "my attributes");
    }

    @Test
    public void parameterGroupWithOptional() throws Exception {
        this.assertMessage(this.getSourceSampleByLocation("parameterGroupWithOptional"), "my payload", "<<null>>");
    }

    @Test
    public void showInDslParameterGroup() throws Exception {
        this.assertMessage(this.getSourceSampleByLocation("showInDslParameterGroup"), "my payload", "my attributes");
    }

    @Test
    public void aliasedGroup() throws Exception {
        this.assertMessage(this.getSourceSampleByLocation("aliasedGroup"), "my payload", "my attributes");
    }

    @Test
    public void missingActingParameter() throws Exception {
        this.assertError(this.getSourceSampleByLocation("missingActingParameter"), "MISSING_REQUIRED_PARAMETERS", "Unable to retrieve Sample Data. There are missing required parameters for the resolution: [attributes]");
    }

    @Test
    public void missingActingParameterInGroup() throws Exception {
        this.assertError(this.getSourceSampleByLocation("missingActingParameterInGroup"), "MISSING_REQUIRED_PARAMETERS", "Unable to retrieve Sample Data. There are missing required parameters for the resolution: [attributes]");
    }

    @Test
    public void muleContextAwareSampleData() throws Exception {
        this.assertMessage(this.getSourceSampleByLocation("muleContextAwareSampleData"), "my payload", "my attributes");
    }

    @Test
    public void complexActingParameter() throws Exception {
        this.assertMessage(this.getSourceSampleByLocation("complexActingParameter"), "my payload", "my attributes");
    }

    @Test
    public void connectionLessWithTwoBoundActingParameter() throws Exception {
        this.assertMessage(this.getSourceSampleByLocation("connectionLessWithBoundActingParameter"), "my payload", "my attributes");
    }

    @Test
    public void sampleDataExceptionWithErrorCause() throws Exception {
        this.assertError(this.getSourceSampleByLocation("sampleDataExceptionWithErrorCause"), "SAMPLE_DATA_FAILURE", "Sample data error", IllegalStateException.class);
    }

    @Test
    public void sampleDataExceptionWithoutErrorCause() throws Exception {
        this.assertError(this.getSourceSampleByLocation("sampleDataExceptionWithoutErrorCause"), "SAMPLE_DATA_FAILURE", "Sample data error");
    }

    public void customSampleDataExceptionWithErrorCause() throws Exception {
        this.assertError(this.getSourceSampleByLocation("customSampleDataExceptionWithErrorCause"), "SAMPLE_DATA_FAILURE", "Custom sample data error", IllegalStateException.class);
    }

    @Test
    public void customSampleDataExceptionWithoutErrorCause() throws Exception {
        this.assertError(this.getSourceSampleByLocation("customSampleDataExceptionWithoutErrorCause"), "SAMPLE_DATA_FAILURE", "Custom sample data error");
    }
}

