/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.scopes;

import io.qameta.allure.Feature;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsNot;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.heisenberg.extension.HeisenbergOperationLifecycleValidator;
import org.mule.test.heisenberg.extension.model.Ricin;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class RoutersExecutionTestCase
extends AbstractExtensionFunctionalTestCase {
    private static final String KILL_REASON = "I'm the one who knocks";
    @Rule
    public SystemProperty maxRedelivery = new SystemProperty("killingReason", "I'm the one who knocks");
    private ExecutorService executor = null;

    protected String[] getConfigFiles() {
        return new String[]{"scopes/heisenberg-router-config.xml"};
    }

    protected boolean isDisposeContextPerClass() {
        return true;
    }

    @Before
    public void before() {
        this.resetExtensionLifecycleCounters();
    }

    @After
    public void after() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    @Test
    public void voidRouter() throws Exception {
        CoreEvent internalEvent = ((FlowRunner)((FlowRunner)this.flowRunner("voidRouter").withPayload((Object)"message")).withAttributes((Object)"other")).run();
        MatcherAssert.assertThat((Object)internalEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"message"));
        MatcherAssert.assertThat((Object)internalEvent.getMessage().getAttributes().getValue(), (Matcher)CoreMatchers.is((Object)"other"));
        MatcherAssert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("newAttributes")), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void sdkVoidRouter() throws Exception {
        CoreEvent internalEvent = ((FlowRunner)((FlowRunner)this.flowRunner("sdkVoidRouter").withPayload((Object)"message")).withAttributes((Object)"other")).run();
        MatcherAssert.assertThat((Object)internalEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"message"));
        MatcherAssert.assertThat((Object)internalEvent.getMessage().getAttributes().getValue(), (Matcher)CoreMatchers.is((Object)"other"));
        MatcherAssert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("newAttributes")), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void fieldParameterInjection() throws Exception {
        Integer value = (Integer)((FlowRunner)((FlowRunner)this.flowRunner("routerField").withVariable("expected", (Object)0)).withVariable("newValue", (Object)1)).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)1));
        value = (Integer)((FlowRunner)((FlowRunner)this.flowRunner("routerField").withVariable("expected", (Object)1)).withVariable("newValue", (Object)5)).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)5));
    }

    @Test
    public void singleRouteRouter() throws Exception {
        CoreEvent internalEvent = ((FlowRunner)((FlowRunner)this.flowRunner("singleRouteRouter").withPayload((Object)"message")).withAttributes((Object)"other")).run();
        MatcherAssert.assertThat((Object)internalEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"message"));
        MatcherAssert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("newPayload")).getValue(), (Matcher)CoreMatchers.is((Object)"message"));
        MatcherAssert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("newAttributes")).getValue(), (Matcher)CoreMatchers.is((Object)"other"));
    }

    @Test
    public void concurrentRouter() throws Exception {
        CoreEvent internalEvent = this.flowRunner("concurrentRouteExecutor").run();
        MatcherAssert.assertThat((Object)internalEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"SUCCESS"));
    }

    @Test
    public void concurrentRouterExecution() throws Exception {
        this.executor = Executors.newFixedThreadPool(2);
        Latch beginLatch = new Latch();
        CountDownLatch assertLatch = new CountDownLatch(2);
        Consumer<Reference> runner = reference -> {
            try {
                beginLatch.await(10000L, TimeUnit.MILLISECONDS);
                reference.set((Object)((FlowRunner)this.flowRunner("singleRouteRouter").withPayload((Object)"CustomPayload")).run());
                assertLatch.countDown();
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
        };
        Reference first = new Reference();
        Reference second = new Reference();
        this.executor.submit(() -> runner.accept(first));
        this.executor.submit(() -> runner.accept(second));
        beginLatch.release();
        assertLatch.await(10000L, TimeUnit.MILLISECONDS);
        CoreEvent firstResult = (CoreEvent)first.get();
        MatcherAssert.assertThat((Object)firstResult, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        CoreEvent secondResult = (CoreEvent)second.get();
        MatcherAssert.assertThat((Object)secondResult, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)secondResult, (Matcher)CoreMatchers.is((Matcher)IsNot.not((Matcher)CoreMatchers.sameInstance((Object)firstResult))));
        MatcherAssert.assertThat((Object)firstResult.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"CustomPayload"));
        MatcherAssert.assertThat((Object)secondResult.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"CustomPayload"));
    }

    @Test
    public void twoRoutesRouterWhen() throws Exception {
        CoreEvent internalEvent = ((FlowRunner)((FlowRunner)this.flowRunner("twoRoutesRouter").withVariable("executeWhen", (Object)true)).withVariable("executeOther", (Object)false)).run();
        MatcherAssert.assertThat((Object)internalEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"mule:set-payload"));
        MatcherAssert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("newPayload")).getValue(), (Matcher)CoreMatchers.is((Object)"mule:set-payload"));
    }

    @Test
    public void twoRoutesRouterOther() throws Exception {
        CoreEvent internalEvent = ((FlowRunner)((FlowRunner)this.flowRunner("twoRoutesRouter").withVariable("executeWhen", (Object)false)).withVariable("executeOther", (Object)true)).run();
        MatcherAssert.assertThat((Object)internalEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"mule:set-payload"));
        MatcherAssert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("newPayload")), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("newAttributes")), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void twoRoutesRouterNone() {
        Exception thrown = (Exception)Assert.assertThrows(Exception.class, () -> this.runFlow("twoRoutesRouterNone"));
        MatcherAssert.assertThat((Object)thrown.getCause(), (Matcher)CoreMatchers.instanceOf(ConnectionException.class));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)CoreMatchers.containsString((String)"No route executed"));
    }

    @Test
    @Feature(value="SDK routers with list of routes")
    public void listOfRoutesRouterWhen() throws Exception {
        CoreEvent internalEvent = ((FlowRunner)((FlowRunner)((FlowRunner)((FlowRunner)this.flowRunner("listOfRoutesRouter").withVariable("executeWhen1", (Object)true)).withVariable("executeWhen2", (Object)false)).withVariable("executeWhen3", (Object)true)).withVariable("executeOther", (Object)false)).run();
        MatcherAssert.assertThat((Object)internalEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"mule:set-payload13"));
    }

    @Test
    @Feature(value="SDK routers with list of routes")
    public void listOfRoutesRouterOther() throws Exception {
        CoreEvent internalEvent = ((FlowRunner)((FlowRunner)((FlowRunner)((FlowRunner)this.flowRunner("listOfRoutesRouter").withVariable("executeWhen1", (Object)false)).withVariable("executeWhen2", (Object)false)).withVariable("executeWhen3", (Object)false)).withVariable("executeOther", (Object)true)).run();
        MatcherAssert.assertThat((Object)internalEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"mule:set-payload"));
        MatcherAssert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("newPayload1")), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("newPayload2")), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("newPayload3")), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("newAttributes1")), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("newAttributes2")), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("newAttributes3")), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void stereotypedRoutes() throws Exception {
        CoreEvent routeEvent = this.flowRunner("stereotypedRoutes").run();
        Ricin ricin = (Ricin)((List)routeEvent.getMessage().getPayload().getValue()).get(0);
        MatcherAssert.assertThat((Object)ricin.getDestination().getVictim(), (Matcher)CoreMatchers.is((Object)"bye bye, someName"));
    }

    @Test
    public void munitSpy() throws Exception {
        CoreEvent internalEvent = this.flowRunner("munitSpy").run();
        MatcherAssert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("before")).getValue(), (Matcher)CoreMatchers.is((Object)"true"));
        MatcherAssert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("after")).getValue(), (Matcher)CoreMatchers.is((Object)"true"));
    }

    @Test
    public void munitSpyNoBefore() throws Exception {
        CoreEvent internalEvent = this.flowRunner("munitSpyNoBefore").run();
        MatcherAssert.assertThat((Object)internalEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"1"));
        MatcherAssert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("before")), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("after")).getValue(), (Matcher)CoreMatchers.is((Object)"true"));
    }

    @Test
    public void munitSpyNoAfter() throws Exception {
        CoreEvent internalEvent = this.flowRunner("munitSpyNoAfter").run();
        MatcherAssert.assertThat((Object)internalEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"2"));
        MatcherAssert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("before")).getValue(), (Matcher)CoreMatchers.is((Object)"true"));
        MatcherAssert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("after")), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void munitSpyNoAttributes() throws Exception {
        CoreEvent internalEvent = this.flowRunner("munitSpyNoAttributes").run();
        MatcherAssert.assertThat((Object)internalEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("before")), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("after")), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void twoRoutesRouterLazilyStarted() throws Exception {
        CoreEvent internalEvent = ((FlowRunner)((FlowRunner)this.flowRunner("twoRoutesRouterLazilyStarted").withVariable("executeWhen", (Object)true)).withVariable("executeOther", (Object)false)).run();
        MatcherAssert.assertThat((Object)internalEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"mule:set-payload"));
        MatcherAssert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("newPayload")).getValue(), (Matcher)CoreMatchers.is((Object)"mule:set-payload"));
    }

    @Test
    public void twoRoutesRouterWithCustomOperationLazilyStarted() throws Exception {
        CoreEvent internalEvent = ((FlowRunner)((FlowRunner)this.flowRunner("twoRoutesRouterWithCustomOperationLazilyStarted").withVariable("executeWhen", (Object)true)).withVariable("executeOther", (Object)false)).run();
        MatcherAssert.assertThat((Object)internalEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"mule:set-payload"));
        MatcherAssert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("newPayload")).getValue(), (Matcher)CoreMatchers.is((Object)"mule:set-payload"));
    }

    @Test
    public void routerLifecycleIsAttachedToFlowLifecycle() throws Exception {
        FlowConstruct flow = this.getFlowConstruct("routerLifecycleIsAttachedToFlowLifecycle");
        MatcherAssert.assertThat((Object)flow.getLifecycleState().isStopped(), (Matcher)CoreMatchers.is((Object)true));
        this.resetExtensionLifecycleCounters();
        ((Startable)flow).start();
        this.assertLifecycleMethodsCalls(0, 2, 0, 0);
        this.resetExtensionLifecycleCounters();
        ((Stoppable)flow).stop();
        this.assertLifecycleMethodsCalls(0, 0, 2, 0);
        this.resetExtensionLifecycleCounters();
        ((Disposable)flow).dispose();
        this.assertLifecycleMethodsCalls(0, 0, 0, 2);
    }

    private void assertLifecycleMethodsCalls(int initializeCalls, int startCalls, int stopCalls, int disposeCalls) {
        MatcherAssert.assertThat((Object)HeisenbergOperationLifecycleValidator.INITIALIZE_CALL_COUNT, (Matcher)CoreMatchers.is((Object)initializeCalls));
        MatcherAssert.assertThat((Object)HeisenbergOperationLifecycleValidator.START_CALL_COUNT, (Matcher)CoreMatchers.is((Object)startCalls));
        MatcherAssert.assertThat((Object)HeisenbergOperationLifecycleValidator.STOP_CALL_COUNT, (Matcher)CoreMatchers.is((Object)stopCalls));
        MatcherAssert.assertThat((Object)HeisenbergOperationLifecycleValidator.DISPOSE_CALL_COUNT, (Matcher)CoreMatchers.is((Object)disposeCalls));
    }

    private void resetExtensionLifecycleCounters() {
        HeisenbergOperationLifecycleValidator.DISPOSE_CALL_COUNT = 0;
        HeisenbergOperationLifecycleValidator.STOP_CALL_COUNT = 0;
        HeisenbergOperationLifecycleValidator.START_CALL_COUNT = 0;
        HeisenbergOperationLifecycleValidator.INITIALIZE_CALL_COUNT = 0;
    }
}

