/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.streaming;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.Is;
import org.hamcrest.number.OrderingComparison;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.matchers.ThrowableCauseMatcher;
import org.mule.functional.junit4.matchers.ThrowableMessageMatcher;
import org.mule.runtime.api.exception.ComposedErrorException;
import org.mule.runtime.core.api.event.EventContextService;
import org.mule.runtime.core.privileged.exception.MessagingException;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

@Features(value={@Feature(value="Streaming"), @Feature(value="Fork/Join Strategies used by scatter-gather and parallel-foreach routers")})
@Story(value="Bytes Streaming")
public class ScatterGatherTimeoutDontCompleteWithBytesStreamingExtensionTestCase
extends AbstractExtensionFunctionalTestCase {
    private static final String DATA = RandomStringUtils.insecure().nextAlphabetic(2048);
    @ClassRule
    public static SystemProperty DISABLE_FEATURE = new SystemProperty("mule.forkJoin.completeChildContextsOnTimeout", "false");
    @ClassRule
    public static SystemProperty CONFIG_NAME = new SystemProperty("configName", "drStrange");
    @Inject
    private EventContextService eventContextService;

    protected String getConfigFile() {
        return "streaming/scatter-gather-bytes-streaming-extension-config.xml";
    }

    @Test
    @Issue(value="W-16941297")
    @Description(value="A Scatter Gather router will time out while an operation is still executing. The operation then finishes and generates a stream which will not be closed because the feature flag is disabled.")
    public void whenScatterGatherTimesOutThenStreamsAreLeaked() throws InterruptedException {
        CountDownLatch sgTimedOutLatch = new CountDownLatch(1);
        CountDownLatch pagingProviderClosedLatch = new CountDownLatch(1);
        MessagingException e = (MessagingException)Assert.assertThrows(MessagingException.class, () -> ((FlowRunner)((FlowRunner)((FlowRunner)this.flowRunner("scatterGatherWithTimeout").withPayload(Collections.singletonList(DATA))).withVariable("latch", (Object)sgTimedOutLatch)).withVariable("providerClosedLatch", (Object)pagingProviderClosedLatch)).run());
        MatcherAssert.assertThat((Object)e, (Matcher)ThrowableCauseMatcher.hasCause((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Is.isA(ComposedErrorException.class), ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Route 1: java.util.concurrent.TimeoutException: Timeout while processing route/part: '1'"))})));
        sgTimedOutLatch.countDown();
        MatcherAssert.assertThat((String)"Paging provider should not have been closed", (Object)pagingProviderClosedLatch.await(5L, TimeUnit.SECONDS), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.eventContextService.getCurrentlyActiveFlowStacks(), (Matcher)IsCollectionWithSize.hasSize((Matcher)OrderingComparison.greaterThan((Comparable)Integer.valueOf(0))));
    }
}

