/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.config;

import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.functional.junit4.ExtensionFunctionalTestCase;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.ExternalLibraryType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.builders.AbstractConfigurationBuilder;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.runtime.extension.api.annotation.Export;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.ExternalLib;
import org.mule.runtime.extension.api.annotation.OnException;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.SubTypeMapping;
import org.mule.runtime.extension.api.annotation.SubTypesMapping;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.sdk.api.annotation.Sources;
import org.mule.sdk.api.annotation.error.ErrorTypes;
import org.mule.test.heisenberg.extension.AsyncHeisenbergSource;
import org.mule.test.heisenberg.extension.DEARadioSource;
import org.mule.test.heisenberg.extension.HeisenbergConnectionProvider;
import org.mule.test.heisenberg.extension.HeisenbergErrors;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.heisenberg.extension.HeisenbergOperations;
import org.mule.test.heisenberg.extension.HeisenbergRouters;
import org.mule.test.heisenberg.extension.HeisenbergScopes;
import org.mule.test.heisenberg.extension.HeisenbergSource;
import org.mule.test.heisenberg.extension.KillingOperations;
import org.mule.test.heisenberg.extension.MoneyLaunderingOperation;
import org.mule.test.heisenberg.extension.ReconnectableHeisenbergSource;
import org.mule.test.heisenberg.extension.SecureHeisenbergConnectionProvider;
import org.mule.test.heisenberg.extension.exception.HeisenbergConnectionExceptionEnricher;
import org.mule.test.heisenberg.extension.exception.HeisenbergException;
import org.mule.test.heisenberg.extension.model.CarDealer;
import org.mule.test.heisenberg.extension.model.CarWash;
import org.mule.test.heisenberg.extension.model.Investment;
import org.mule.test.heisenberg.extension.model.Ricin;
import org.mule.test.heisenberg.extension.model.Weapon;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

public class ConfigurationInjectionLifecycleTestCase
extends ExtensionFunctionalTestCase {
    protected String getConfigFile() {
        return "heisenberg-io-config.xml";
    }

    protected Class<?>[] getAnnotatedExtensionClasses() {
        return new Class[]{DIHeisenbergExtension.class};
    }

    protected void addBuilders(List<ConfigurationBuilder> builders) {
        builders.add((ConfigurationBuilder)new AbstractConfigurationBuilder(){

            protected void doConfigure(MuleContext muleContext) throws Exception {
                muleContext.getCustomizationService().registerCustomServiceClass("lifecycleTracker", LifecycleTracker.class);
            }
        });
        builders.add(ConfigurationInjectionLifecycleTestCase.extensionManagerWithMuleExtModelBuilder(Collections.singleton(MuleExtensionModelProvider.getExtensionModel())));
        super.addBuilders(builders);
    }

    @Test
    public void injectedDependencyLifecycle() throws Exception {
        DIHeisenbergExtension heisenberg = (DIHeisenbergExtension)((Object)ExtensionsTestUtils.getConfigurationInstanceFromRegistry((String)"heisenberg", (CoreEvent)this.testEvent(), (MuleContext)muleContext).getValue());
        LifecycleTracker tracker = heisenberg.getLifecycleTracker();
        MatcherAssert.assertThat((Object)tracker.initialise, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)tracker.start, (Matcher)CoreMatchers.is((Object)1));
    }

    @Extension(name="Heisenberg", category=Category.SELECT)
    @Operations(value={HeisenbergOperations.class, MoneyLaunderingOperation.class, KillingOperations.class, HeisenbergScopes.class, HeisenbergRouters.class})
    @OnException(value=HeisenbergConnectionExceptionEnricher.class)
    @ConnectionProviders(value={HeisenbergConnectionProvider.class, SecureHeisenbergConnectionProvider.class})
    @org.mule.runtime.extension.api.annotation.Sources(value={HeisenbergSource.class, DEARadioSource.class, AsyncHeisenbergSource.class})
    @Sources(value={ReconnectableHeisenbergSource.class})
    @Export(classes={HeisenbergExtension.class, HeisenbergException.class}, resources={"methRecipe.json"})
    @SubTypesMapping(value={@SubTypeMapping(baseType=Weapon.class, subTypes={Ricin.class}), @SubTypeMapping(baseType=Investment.class, subTypes={CarWash.class, CarDealer.class})})
    @ExternalLib(name="Heisenberg.so", description="Native Heisenberg support", nameRegexpMatcher="heisenberg.so", requiredClassName="org.heisenberg.HeisenbergJNI", type=ExternalLibraryType.NATIVE, coordinates="org.mule.libs:this-is-a-lib:dll:1.0.0")
    @ErrorTypes(value=HeisenbergErrors.class)
    public static class DIHeisenbergExtension
    extends HeisenbergExtension {
        @Inject
        private LifecycleTracker lifecycleTracker;

        public void initialise() throws InitialisationException {
            if (this.lifecycleTracker.initialise != 1) {
                throw new IllegalStateException("initialise was " + this.lifecycleTracker.initialise);
            }
            super.initialise();
        }

        public LifecycleTracker getLifecycleTracker() {
            return this.lifecycleTracker;
        }
    }

    public static class LifecycleTracker
    implements Initialisable,
    Startable {
        private int initialise;
        private int start;

        public void initialise() throws InitialisationException {
            ++this.initialise;
        }

        public void start() throws MuleException {
            ++this.start;
        }
    }
}

