/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsEmptyCollection;
import org.junit.Test;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.vegan.extension.BananaConfig;
import org.mule.test.vegan.extension.FarmedFood;
import org.mule.test.vegan.extension.HealthyFood;
import org.mule.test.vegan.extension.RottenFood;
import org.mule.test.vegan.extension.VeganPolicy;

public class NullSafeParameterTestCase
extends AbstractExtensionFunctionalTestCase {
    @Inject
    @Named(value="nullSafeOnSourceGroupAndPojo")
    private Flow nullSafeOnSourceGroupAndPojoFlow;

    protected String getConfigFile() {
        return "vegan-null-safe-operation.xml";
    }

    protected boolean isDisposeContextPerClass() {
        return true;
    }

    @Test
    public void getNullSafeObject() throws Exception {
        VeganPolicy policy = (VeganPolicy)this.flowRunner("policy").run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)policy, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)policy.getMeetAllowed(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)policy.getIngredients(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)policy.getIngredients().getSaltMiligrams(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)policy.getIngredients().getSaltReplacementName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void getNullSafeAbstractObjectWithDefault() throws Exception {
        FarmedFood response = (FarmedFood)this.flowRunner("implementingType").run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.instanceOf(HealthyFood.class));
        MatcherAssert.assertThat((Object)response.canBeEaten(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void nestedNullSafe() throws Exception {
        this.assertNestedNullSafe("implementingType");
    }

    private void assertNestedNullSafe(String flowName) throws Exception {
        FarmedFood response = (FarmedFood)this.flowRunner(flowName).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(HealthyFood.class)));
        HealthyFood healthyFood = (HealthyFood)response;
        this.assertHealthyFood(healthyFood);
    }

    @Test
    public void topLevelNestedNullSafe() throws Exception {
        this.assertNestedNullSafe("topLevelNullSafe");
    }

    private void assertHealthyFood(HealthyFood healthyFood) {
        MatcherAssert.assertThat((Object)healthyFood.getTasteProfile(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)healthyFood.getTasteProfile().isTasty(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void nestedNullSafeInConfig() throws Exception {
        BananaConfig config = (BananaConfig)this.flowRunner("inConfig").run().getMessage().getPayload().getValue();
        this.assertHealthyFood(config.getHealthyFood());
    }

    @Test
    public void nullSafeOnMap() throws Exception {
        TypedValue payload = this.flowRunner("nullSafeOnMap").run().getMessage().getPayload();
        Object nullSafeMap = payload.getValue();
        MatcherAssert.assertThat((Object)nullSafeMap, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Map.class)));
        MatcherAssert.assertThat((Object)((Map)nullSafeMap).isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void nullSafeOnList() throws Exception {
        TypedValue payload = this.flowRunner("nullSafeOnList").run().getMessage().getPayload();
        Object nullSafeMap = payload.getValue();
        MatcherAssert.assertThat((Object)nullSafeMap, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(List.class)));
        MatcherAssert.assertThat((Object)((List)nullSafeMap), (Matcher)CoreMatchers.is((Matcher)IsEmptyCollection.empty()));
    }

    @Test
    public void nullSafeOnGroupAndPojo() throws Exception {
        TypedValue payload = this.flowRunner("nullSafeOnGroupAndPojo").run().getMessage().getPayload();
        Object listOfNullsafes = payload.getValue();
        MatcherAssert.assertThat((Object)listOfNullsafes, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(List.class)));
        MatcherAssert.assertThat(((List)listOfNullsafes).get(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(RottenFood.class)));
        MatcherAssert.assertThat(((List)listOfNullsafes).get(1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(RottenFood.class)));
    }

    @Test
    public void nullSafeOnSourceGroupAndPojo() throws Exception {
        this.nullSafeOnSourceGroupAndPojoFlow.start();
        MatcherAssert.assertThat((Object)this.nullSafeOnSourceGroupAndPojoFlow.getLifecycleState().isStarted(), (Matcher)CoreMatchers.is((Object)true));
    }
}

