/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.data.sample;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.junit.Test;
import org.mule.test.module.extension.data.sample.AbstractSampleDataTestCase;

@Feature(value="SDK Tooling Support")
@Story(value="Resolve by location")
public class OperationSampleDataByLocationTestCase
extends AbstractSampleDataTestCase {
    protected String getConfigFile() {
        return "data/sample/operation-sample-data.xml";
    }

    @Test
    public void connectionLess() throws Exception {
        this.assertMessage(this.getOperationSampleByLocation("connectionLess"), "my payload", "my attributes");
    }

    @Test
    public void useConnection() throws Exception {
        this.assertMessage(this.getOperationSampleByLocation("useConnection"), "my payload", "my attributes");
    }

    @Test
    public void nonBlocking() throws Exception {
        this.assertMessage(this.getOperationSampleByLocation("nonBlocking"), "my payload", "my attributes");
    }

    @Test
    public void useConfig() throws Exception {
        this.assertMessage(this.getOperationSampleByLocation("useConfig"), "from-conf-my payload", "from-conf-my attributes");
    }

    @Test
    public void parameterGroup() throws Exception {
        this.assertMessage(this.getOperationSampleByLocation("parameterGroup"), "my payload", "my attributes");
    }

    @Test
    public void parameterGroupWithOptional() throws Exception {
        this.assertMessage(this.getOperationSampleByLocation("parameterGroupWithOptional"), "my payload", "<<null>>");
    }

    @Test
    public void showInDslParameterGroup() throws Exception {
        this.assertMessage(this.getOperationSampleByLocation("showInDslParameterGroup"), "my payload", "my attributes");
    }

    @Test
    public void aliasedGroup() throws Exception {
        this.assertMessage(this.getOperationSampleByLocation("aliasedGroup"), "my payload", "my attributes");
    }

    @Test
    public void missingActingParameter() throws Exception {
        this.assertError(this.getOperationSampleByLocation("missingActingParameter"), "MISSING_REQUIRED_PARAMETERS", "Unable to retrieve Sample Data. There are missing required parameters for the resolution: [attributes]");
    }

    @Test
    public void muleContextAwareSampleData() throws Exception {
        this.assertMessage(this.getOperationSampleByLocation("muleContextAwareSampleData"), "my payload", "my attributes");
    }

    @Test
    public void complexActingParameter() throws Exception {
        this.assertMessage(this.getOperationSampleByLocation("complexActingParameter"), "my payload", "my attributes");
    }

    @Test
    public void connectionLessWithTwoBoundActingParameter() throws Exception {
        this.assertMessage(this.getOperationSampleByLocation("connectionLessWithTwoBoundActingParameter"), "my payload", "my attributes");
    }

    @Test
    public void connectionLessWithTwoBoundActingParameterOneWithAnAlias() throws Exception {
        this.assertMessage(this.getOperationSampleByLocation("connectionLessWithTwoBoundActingParameterOneWithAnAlias"), "my payload", "my attributes");
    }

    @Test
    public void connectionLessWithTwoBoundActingParameterFromContentField() throws Exception {
        this.assertMessage(this.getOperationSampleByLocation("connectionLessWithTwoBoundActingParameterFromContentField"), "my payload", "my attributes");
    }

    @Test
    public void connectionLessWithTwoBoundActingParameterFromXMLContentTag() throws Exception {
        this.assertMessage(this.getOperationSampleByLocation("connectionLessWithTwoBoundActingParameterFromXMLContentTag"), "my payload", "my attributes");
    }

    @Test
    public void connectionLessWithTwoBoundActingParameterFromXMLContentTagAttribute() throws Exception {
        this.assertMessage(this.getOperationSampleByLocation("connectionLessWithTwoBoundActingParameterFromXMLContentTagAttribute"), "my payload", "my attributes");
    }

    @Test
    public void useConnectionWithTwoBoundActingParameter() throws Exception {
        this.assertMessage(this.getOperationSampleByLocation("useConnectionWithTwoBoundActingParameter"), "my payload", "my attributes");
    }

    @Test
    public void missingBoundActingParameter() throws Exception {
        this.assertError(this.getOperationSampleByLocation("missingBoundActingParameter"), "MISSING_REQUIRED_PARAMETERS", "Unable to retrieve Sample Data. There are missing required parameters for the resolution: [attributes]");
    }

    @Test
    public void missingBoundActingParameterFromContentField() throws Exception {
        this.assertError(this.getOperationSampleByLocation("missingBoundActingParameterFromContentField"), "MISSING_REQUIRED_PARAMETERS", "Unable to retrieve Sample Data. There are missing required parameters for the resolution: [attributes]");
    }

    @Test
    public void complexBoundActingParameter() throws Exception {
        this.assertMessage(this.getOperationSampleByLocation("complexBoundActingParameter"), "my payload", "my attributes");
    }

    @Test
    public void pojoBoundActingParameter() throws Exception {
        this.assertMessage(this.getOperationSampleByLocation("pojoBoundActingParameter"), "my payload", "my attributes");
    }

    @Test
    public void boundActingParameterFromPojoFieldWithExpression() throws Exception {
        this.assertMessage(this.getOperationSampleByLocation("boundActingParameterFromPojoFieldWithExpression"), "my payload", "my attributes");
    }

    @Test
    public void boundActingParameterFromPojoFieldWithDsl() throws Exception {
        this.assertMessage(this.getOperationSampleByLocation("boundActingParameterFromPojoFieldWithExpression"), "my payload", "my attributes");
    }

    @Test
    public void sampleDataExceptionWithErrorCause() throws Exception {
        this.assertError(this.getOperationSampleByLocation("sampleDataExceptionWithErrorCause"), "SAMPLE_DATA_FAILURE", "Sample data error");
    }

    @Test
    public void sampleDataExceptionWithoutErrorCause() throws Exception {
        this.assertError(this.getOperationSampleByLocation("sampleDataExceptionWithoutErrorCause"), "SAMPLE_DATA_FAILURE", "Sample data error");
    }

    @Test
    public void customSampleDataExceptionWithErrorCause() throws Exception {
        this.assertError(this.getOperationSampleByLocation("customSampleDataExceptionWithErrorCause"), "SAMPLE_DATA_FAILURE", "Custom sample data error", IllegalStateException.class);
    }

    @Test
    public void customSampleDataExceptionWithoutErrorCause() throws Exception {
        this.assertError(this.getOperationSampleByLocation("customSampleDataExceptionWithoutErrorCause"), "SAMPLE_DATA_FAILURE", "Custom sample data error");
    }
}

