/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.values;

import com.google.common.base.Throwables;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.api.value.ResolvingFailure;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.api.value.ValueResult;
import org.mule.runtime.core.internal.util.ClassUtils;
import org.mule.runtime.extension.api.property.ClassLoaderModelProperty;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.values.ValueResolvingException;
import org.mule.runtime.module.extension.api.runtime.config.ExtensionDesignTimeResolversFactory;
import org.mule.runtime.module.extension.api.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.api.tooling.valueprovider.ValueProviderMediator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueProviderExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValueProviderExecutor.class);
    public static final String INVALID_PARAMETER_VALUE = "INVALID_PARAMETER_VALUE";
    private final ExtensionDesignTimeResolversFactory extensionDesignTimeResolversFactory;
    private final ValueProviderMediator valueProviderMediator;
    private final ParameterizedModel parameterizedModel;

    public ValueProviderExecutor(ExtensionDesignTimeResolversFactory extensionDesignTimeResolversFactory, ParameterizedModel parameterizedModel) {
        this.extensionDesignTimeResolversFactory = extensionDesignTimeResolversFactory;
        this.parameterizedModel = parameterizedModel;
        this.valueProviderMediator = this.createValueProviderMediator(parameterizedModel);
    }

    public ValueResult resolveValues(ExtensionModel extensionModel, String providerName, ComponentParameterization actingParameter, Optional<ConfigurationProvider> configurationProvider, String targetSelector) {
        return this.resolveValues(extensionModel, providerName, actingParameter, configurationProvider, (mediator, resolver, selector, connection, config, provider) -> mediator.getValues(providerName, resolver, selector, connection, config, provider), targetSelector, "");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ValueResult resolveValues(ExtensionModel extensionModel, String providerName, ComponentParameterization actingParameter, Optional<ConfigurationProvider> configurationProvider, ValueProviderFunction valueProviderFunction, String targetSelector, String loggingSuffix) {
        ValueResult valueResult;
        block15: {
            if (this.parameterizedModel == actingParameter.getModel()) break block15;
            ValueResult valueResult2 = ValueResult.resultFrom((ResolvingFailure)ResolvingFailure.Builder.newFailure((Throwable)new ValueResolvingException("The parameter model from the acting parameters is different from the one provided in the session", INVALID_PARAMETER_VALUE)).withFailureCode(INVALID_PARAMETER_VALUE).build());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Resolve value provider: {} FINISHED for component: {} {}", new Object[]{providerName, actingParameter.getModel().getName(), loggingSuffix});
            }
            return valueResult2;
        }
        try {
            LOGGER.debug("Resolve value provider: {} STARTED for component: {} {}", new Object[]{providerName, this.parameterizedModel.getName(), loggingSuffix});
            ClassLoader extensionClassLoader = ValueProviderExecutor.getClassLoader(extensionModel);
            LOGGER.debug("Invoking value provider: {} for component: {} {}", new Object[]{providerName, this.parameterizedModel.getName(), loggingSuffix});
            valueResult = (ValueResult)ClassUtils.withContextClassLoader((ClassLoader)extensionClassLoader, () -> {
                ParameterValueResolver parameterValueResolver = this.extensionDesignTimeResolversFactory.createParameterValueResolver(actingParameter, this.parameterizedModel);
                Optional connectionProvider = this.getConnectionProvider(configurationProvider);
                return ValueResult.resultFrom(valueProviderFunction.apply(this.valueProviderMediator, parameterValueResolver, targetSelector, this.connectionSupplier(connectionProvider), configurationProvider.map(this::configSupplier).orElse(() -> null), connectionProvider.orElse(null)));
            }, ValueResolvingException.class, e -> {
                throw new MuleRuntimeException((Throwable)e);
            });
        }
        catch (ValueResolvingException e2) {
            LOGGER.warn(String.format("Resolve value provider has FAILED with code: %s for component: %s %s", e2.getFailureCode(), actingParameter.getModel().getName(), loggingSuffix), (Throwable)e2);
            ValueResult valueResult3 = ValueResult.resultFrom((ResolvingFailure)ResolvingFailure.Builder.newFailure((Throwable)e2).withFailureCode(e2.getFailureCode()).build());
            {
                catch (Throwable throwable) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Resolve value provider: {} FINISHED for component: {} {}", new Object[]{providerName, actingParameter.getModel().getName(), loggingSuffix});
                    }
                    throw throwable;
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Resolve value provider: {} FINISHED for component: {} {}", new Object[]{providerName, actingParameter.getModel().getName(), loggingSuffix});
            }
            return valueResult3;
            catch (MuleRuntimeException e3) {
                Throwable cause;
                block16: {
                    cause = e3.getCause();
                    if (!(cause instanceof ValueResolvingException)) break block16;
                    ValueResolvingException valueResolvingException = (ValueResolvingException)cause;
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn(String.format("Resolve value provider has FAILED with code: %s for component: %s %s", valueResolvingException.getFailureCode(), actingParameter.getModel().getName(), loggingSuffix), cause);
                    }
                    ResolvingFailure.Builder failureBuilder = ResolvingFailure.Builder.newFailure((Throwable)cause);
                    failureBuilder.withFailureCode(valueResolvingException.getFailureCode());
                    ValueResult valueResult4 = ValueResult.resultFrom((ResolvingFailure)failureBuilder.build());
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Resolve value provider: {} FINISHED for component: {} {}", new Object[]{providerName, actingParameter.getModel().getName(), loggingSuffix});
                    }
                    return valueResult4;
                }
                Throwables.propagateIfPossible((Throwable)cause, MuleRuntimeException.class);
                throw new MuleRuntimeException(cause);
                catch (Exception e4) {
                    Throwables.propagateIfPossible((Throwable)e4, MuleRuntimeException.class);
                    throw new MuleRuntimeException((Throwable)e4);
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Resolve value provider: {} FINISHED for component: {} {}", new Object[]{providerName, actingParameter.getModel().getName(), loggingSuffix});
        }
        return valueResult;
    }

    private Supplier<Object> configSupplier(ConfigurationProvider configurationProvider) {
        return () -> configurationProvider.get(null).getValue();
    }

    private <C> Optional<ConnectionProvider<C>> getConnectionProvider(Optional<ConfigurationProvider> configurationProvider) {
        return configurationProvider.flatMap(cp -> cp.get(null).getConnectionProvider());
    }

    private <C> Supplier<C> connectionSupplier(Optional<ConnectionProvider<C>> connectionProvider) {
        return () -> connectionProvider.map(cp -> {
            try {
                return cp.connect();
            }
            catch (ConnectionException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }).orElse(null);
    }

    public static ClassLoader getClassLoader(ExtensionModel extensionModel) {
        return extensionModel.getModelProperty(ClassLoaderModelProperty.class).map(ClassLoaderModelProperty::getClassLoader).orElse(Thread.currentThread().getContextClassLoader());
    }

    private ValueProviderMediator createValueProviderMediator(ParameterizedModel parameterizedModel) {
        return this.extensionDesignTimeResolversFactory.createValueProviderMediator(parameterizedModel);
    }

    @FunctionalInterface
    private static interface ValueProviderFunction {
        public Set<Value> apply(ValueProviderMediator var1, ParameterValueResolver var2, String var3, Supplier<Object> var4, Supplier<Object> var5, ConnectionProvider var6) throws ValueResolvingException;
    }
}

