/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.connector;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.matchers.MessageMatchers;
import org.mule.functional.junit4.matchers.ThatMatcher;
import org.mule.tck.junit4.matcher.ErrorTypeMatcher;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

@Feature(value="Error Handling")
@Story(value="Error Mappings")
public class PetStoreErrorMappingsTestCase
extends AbstractExtensionFunctionalTestCase {
    private static final String CONNECT_ERROR_MESSAGE = "Could not connect.";
    private static final String UNMATCHED_ERROR_MESSAGE = "Error.";
    private static final String EXPRESSION_ERROR_MESSAGE = "Bad expression.";

    protected String getConfigFile() {
        return "petstore-error-mappings.xml";
    }

    @Test
    @Description(value="Verifies that an unmapped error is handled as ANY.")
    public void simpleRequest() throws Exception {
        this.verify("noMapping", UNMATCHED_ERROR_MESSAGE);
    }

    @Test
    @Description(value="Verifies that a mapped error via wildcard is handled.")
    public void mappedRequest() throws Exception {
        this.verify("simpleMapping", CONNECT_ERROR_MESSAGE);
    }

    @Test
    @Description(value="Verifies that a mapped error via a custom matcher is handled. ")
    public void matchingMappedRequest() throws Exception {
        this.verify("complexMapping", CONNECT_ERROR_MESSAGE);
    }

    @Test
    @Description(value="Verifies that an unmapped error is handled as ANY.")
    public void noMatchingMappedRequest() throws Exception {
        this.verifyWithFailingExpression("complexMappingWithFailingExpression", UNMATCHED_ERROR_MESSAGE);
    }

    @Test
    @Description(value="Verifies that each error is correctly handled given an operation with multiple mappings.")
    public void multipleMappingsRequest() throws Exception {
        this.verifyWithFailingExpression("multipleMappings", EXPRESSION_ERROR_MESSAGE);
        this.verify("multipleMappings", CONNECT_ERROR_MESSAGE);
    }

    @Test
    public void raiseErrorInFlow() throws Exception {
        this.flowRunner("raise-error-in-flow").runExpectingException(ErrorTypeMatcher.errorType((String)"APP", (String)"PERRO"));
    }

    @Test
    public void raiseErrorFlowRef() throws Exception {
        this.flowRunner("raise-error-flow-ref").runExpectingException(ErrorTypeMatcher.errorType((String)"APP", (String)"PERRO"));
    }

    @Test
    public void raiseErrorInSubflow() throws Exception {
        this.flowRunner("raise-error-in-subflow").runExpectingException(ErrorTypeMatcher.errorType((String)"APP", (String)"PERRO"));
    }

    private void verifyWithFailingExpression(String flowName, String expectedPayload) throws Exception {
        Assert.assertThat((Object)((FlowRunner)this.flowRunner(flowName).withVariable("failExpression", (Object)true)).run().getMessage(), (Matcher)MessageMatchers.hasPayload((Matcher)ThatMatcher.that((Matcher)Matchers.is((Object)expectedPayload))));
    }

    private void verify(String flowName, String expectedPayload) throws Exception {
        this.verify(flowName, expectedPayload, Collections.emptyMap());
    }

    private void verify(String flowName, String expectedPayload, Object petNames) throws Exception {
        Assert.assertThat((Object)((FlowRunner)this.flowRunner(flowName).withVariable("names", petNames)).run().getMessage(), (Matcher)MessageMatchers.hasPayload((Matcher)ThatMatcher.that((Matcher)Matchers.is((Object)expectedPayload))));
    }
}

