/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.connector;

import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.petstore.extension.PetStoreClient;
import org.mule.test.petstore.extension.PetStoreConnector;

public class PetStoreRuntimeVersionTestCase
extends AbstractExtensionFunctionalTestCase {
    private static final Reference<Message> messageHolder = new Reference();

    protected String getConfigFile() {
        return "petstore-runtime-version.xml";
    }

    @Before
    public void setUp() {
        messageHolder.set(null);
    }

    @Test
    public void configWithRuntimeVersionField() throws Exception {
        PetStoreConnector config = (PetStoreConnector)this.flowRunner("configWithRuntimeVersion").run().getMessage().getPayload().getValue();
        this.assertRuntimeVersion(config.getRuntimeVersion());
    }

    @Test
    public void sourceWithRuntimeVersionField() throws Exception {
        this.startFlow("sourceWithRuntimeVersion");
        MuleVersion muleVersion = (MuleVersion)((Map)this.listen().getAttributes().getValue()).get("muleRuntime");
        this.assertRuntimeVersion(muleVersion);
    }

    @Test
    public void connectionProviderWithRuntimeVersionField() throws Exception {
        PetStoreClient petStoreClient = (PetStoreClient)this.flowRunner("connectionProviderWithRuntimeVersion").run().getMessage().getPayload().getValue();
        this.assertRuntimeVersion(petStoreClient.getMuleVersion());
    }

    @Test
    public void operationClassWithRuntimeVersionField() throws Exception {
        MuleVersion muleVersion = (MuleVersion)this.flowRunner("operationClassWithRuntimeVersion").run().getMessage().getPayload().getValue();
        this.assertRuntimeVersion(muleVersion);
    }

    private void assertRuntimeVersion(MuleVersion muleVersion) {
        MatcherAssert.assertThat((Object)muleVersion, (Matcher)Matchers.notNullValue());
    }

    private void startFlow(String flowName) throws Exception {
        ((Flow)this.getFlowConstruct(flowName)).start();
    }

    private Message listen() {
        PollingProber prober = new PollingProber(10000L, 50L);
        prober.check((Probe)new JUnitLambdaProbe(() -> messageHolder.get() != null));
        return (Message)messageHolder.get();
    }

    public static class TestProcessor
    implements Processor {
        public CoreEvent process(CoreEvent event) throws MuleException {
            messageHolder.set((Object)event.getMessage());
            return event;
        }
    }
}

