/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.dsl;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import jakarta.inject.Inject;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.NameUtils;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.dsl.syntax.resolver.ImportTypesStrategy;
import org.mule.runtime.extension.api.dsl.syntax.resolver.SingleExtensionImportTypesStrategy;
import org.mule.test.heisenberg.extension.model.CarWash;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.subtypes.extension.TopLevelStatelessType;

public class ComplexPojoDslSyntaxResolverTestCase
extends AbstractExtensionFunctionalTestCase {
    private static final String INVESTMENT_PLAN_B_NAME = "investmentPlanB";
    @Inject
    private ExtensionManager extensionManager;
    private ExtensionModel heisenbergExtensionModel;
    private ExtensionModel subTypesExtensionModel;

    protected String getConfigFile() {
        return "source/heisenberg-source-config.xml";
    }

    @Before
    public void setup() {
        this.heisenbergExtensionModel = (ExtensionModel)this.extensionManager.getExtension("Heisenberg").get();
        this.subTypesExtensionModel = (ExtensionModel)this.extensionManager.getExtension("SubtypesConnector").get();
    }

    @Test
    public void innerWrapperPojoIsShownAsChild() {
        DslSyntaxResolver dslSyntaxResolver = DslSyntaxResolver.getDefault((ExtensionModel)this.heisenbergExtensionModel, (ImportTypesStrategy)new SingleExtensionImportTypesStrategy());
        MetadataType carWashType = (MetadataType)this.getSubType(this.heisenbergExtensionModel, CarWash.class).get();
        DslElementSyntax carWashDslElementSyntax = (DslElementSyntax)dslSyntaxResolver.resolve(carWashType).get();
        MatcherAssert.assertThat((Object)carWashDslElementSyntax.getChild(INVESTMENT_PLAN_B_NAME).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        DslElementSyntax investmentPlanBElementSyntax = (DslElementSyntax)carWashDslElementSyntax.getChild(INVESTMENT_PLAN_B_NAME).get();
        MatcherAssert.assertThat((Object)investmentPlanBElementSyntax.supportsChildDeclaration(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)investmentPlanBElementSyntax.getElementName(), (Matcher)CoreMatchers.is((Object)NameUtils.hyphenize((String)INVESTMENT_PLAN_B_NAME)));
    }

    @Test
    @Issue(value="W-14645134")
    @Description(value="Tests that a stateless subtype can be defined as a child element")
    public void statelessSubType() {
        DslSyntaxResolver dslSyntaxResolver = DslSyntaxResolver.getDefault((ExtensionModel)this.subTypesExtensionModel, (ImportTypesStrategy)new SingleExtensionImportTypesStrategy());
        MetadataType type = (MetadataType)this.getSubType(this.subTypesExtensionModel, TopLevelStatelessType.class).get();
        DslElementSyntax syntax = (DslElementSyntax)dslSyntaxResolver.resolve(type).get();
        MatcherAssert.assertThat((Object)syntax.supportsChildDeclaration(), (Matcher)CoreMatchers.is((Object)true));
    }

    private Optional<ObjectType> getSubType(ExtensionModel model, Class<?> clazz) {
        return model.getSubTypes().stream().flatMap(subTypesModel -> subTypesModel.getSubTypes().stream()).filter(t -> t.toString().contains(clazz.getName())).findFirst();
    }
}

