/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsMapContaining;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.matchers.ThrowableRootCauseMatcher;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.extension.api.runtime.parameter.ParameterResolver;
import org.mule.tck.junit4.matcher.DataTypeCompatibilityMatcher;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.heisenberg.extension.exception.HealthException;
import org.mule.test.heisenberg.extension.exception.HeisenbergException;
import org.mule.test.heisenberg.extension.model.BarberPreferences;
import org.mule.test.heisenberg.extension.model.CarDealer;
import org.mule.test.heisenberg.extension.model.CarWash;
import org.mule.test.heisenberg.extension.model.HealthStatus;
import org.mule.test.heisenberg.extension.model.Investment;
import org.mule.test.heisenberg.extension.model.KnockeableDoor;
import org.mule.test.heisenberg.extension.model.PersonalInfo;
import org.mule.test.heisenberg.extension.model.Ricin;
import org.mule.test.heisenberg.extension.model.SaleInfo;
import org.mule.test.heisenberg.extension.model.Weapon;
import org.mule.test.heisenberg.extension.model.types.IntegerAttributes;
import org.mule.test.heisenberg.extension.model.types.WeaponType;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

public class OperationExecutionTestCase
extends AbstractExtensionFunctionalTestCase {
    public static final String HEISENBERG = "heisenberg";
    public static final String KILL_RESULT = String.format("Killed with: %s , Type %s and attribute %s", "You have been killed with Ricin", WeaponType.MELEE_WEAPON.name(), "Pizza on the rooftop");
    private static final String GUSTAVO_FRING = "Gustavo Fring";
    private static final String GOODBYE_MESSAGE = "Say hello to my little friend";
    private static final String VICTIM = "Skyler";
    private static final String EMPTY_STRING = "";

    protected String[] getConfigFiles() {
        return new String[]{"operations/heisenberg-operation-config.xml", "operations/vegan-config.xml", "operations/static-metadata-execution.xml"};
    }

    protected boolean isDisposeContextPerClass() {
        return true;
    }

    @Test
    public void operationWithInjectedObjectsFromRegistry() throws Exception {
        Map result = (Map)this.runFlow("getInjectedObjects").getMessage().getPayload().getValue();
        MatcherAssert.assertThat(result.get("object"), (Matcher)Matchers.instanceOf(Ricin.class));
        MatcherAssert.assertThat(result.get("serializable"), (Matcher)Matchers.instanceOf(Serializable.class));
        MatcherAssert.assertThat(result.get("object"), (Matcher)Matchers.is(this.registry.lookupByName("ricin-weapon").get()));
        MatcherAssert.assertThat(result.get("serializable"), (Matcher)Matchers.is(this.registry.lookupByName("door").get()));
    }

    @Test
    public void operationWithReturnValueAndWithoutParameters() throws Exception {
        MatcherAssert.assertThat((Object)HEISENBERG, (Matcher)CoreMatchers.equalTo((Object)this.runFlow("sayMyName").getMessage().getPayload().getValue()));
    }

    @Test
    public void operationWithReturnValueOnTarget() throws Exception {
        FlowRunner runner = (FlowRunner)this.flowRunner("sayMyNameOnTarget").withPayload((Object)EMPTY_STRING);
        CoreEvent responseEvent = runner.run();
        MatcherAssert.assertThat((Object)responseEvent.getMessage().getPayload().getValue(), (Matcher)Matchers.is((Object)EMPTY_STRING));
        Message responseMessage = (Message)((TypedValue)responseEvent.getVariables().get("myFace")).getValue();
        MatcherAssert.assertThat((Object)responseMessage.getPayload().getValue(), (Matcher)Matchers.is((Object)HEISENBERG));
    }

    @Test
    public void getInlineGroupDefinition() throws Exception {
        Message message = ((FlowRunner)this.flowRunner("getBarberPreferences").withPayload((Object)EMPTY_STRING)).run().getMessage();
        MatcherAssert.assertThat((Object)message.getPayload().getValue(), (Matcher)Matchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)message.getPayload().getDataType().getMediaType().matches(MediaType.APPLICATION_JAVA), (Matcher)Matchers.is((Object)true));
        BarberPreferences preferences = (BarberPreferences)message.getPayload().getValue();
        MatcherAssert.assertThat((Object)preferences.getBeardTrimming(), (Matcher)Matchers.is((Object)BarberPreferences.BEARD_KIND.MUSTACHE));
        MatcherAssert.assertThat((Object)preferences.isFullyBald(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void getInlineGroupDefinitionAsArgument() throws Exception {
        Message message = ((FlowRunner)this.flowRunner("getInlineInfo").withPayload((Object)EMPTY_STRING)).run().getMessage();
        MatcherAssert.assertThat((Object)message.getPayload().getValue(), (Matcher)Matchers.is((Matcher)CoreMatchers.notNullValue()));
        BarberPreferences preferences = (BarberPreferences)message.getPayload().getValue();
        MatcherAssert.assertThat((Object)preferences.getBeardTrimming(), (Matcher)Matchers.is((Object)BarberPreferences.BEARD_KIND.MUSTACHE));
        MatcherAssert.assertThat((Object)preferences.isFullyBald(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void getInlineGroupPersonalInfoAsArgument() throws Exception {
        Message message = ((FlowRunner)this.flowRunner("getInlinePersonalInfo").withPayload((Object)EMPTY_STRING)).run().getMessage();
        MatcherAssert.assertThat((Object)message.getPayload().getValue(), (Matcher)Matchers.is((Matcher)CoreMatchers.notNullValue()));
        PersonalInfo value = (PersonalInfo)message.getPayload().getValue();
        MatcherAssert.assertThat((Object)value.getAge(), (Matcher)Matchers.is((Object)26));
        MatcherAssert.assertThat((Object)((String)value.getKnownAddresses().get(0)), (Matcher)Matchers.is((Object)"explicitAddress"));
        MatcherAssert.assertThat((Object)value.getName(), (Matcher)Matchers.is((Object)"Pepe"));
    }

    @Test
    public void voidOperationWithoutParameters() throws Exception {
        CoreEvent responseEvent = ((FlowRunner)this.flowRunner("die").withPayload((Object)EMPTY_STRING)).run();
        MatcherAssert.assertThat((Object)responseEvent.getMessage().getPayload().getValue(), (Matcher)Matchers.is((Object)EMPTY_STRING));
        MatcherAssert.assertThat((Object)this.getConfig(HEISENBERG).getEndingHealth(), (Matcher)Matchers.is((Object)HealthStatus.DEAD));
    }

    @Test
    public void operationWithFixedParameter() throws Exception {
        MatcherAssert.assertThat((Object)GUSTAVO_FRING, (Matcher)CoreMatchers.equalTo((Object)this.runFlow("getFixedEnemy").getMessage().getPayload().getValue()));
    }

    @Test
    public void operationWithDefaulValueParameter() throws Exception {
        MatcherAssert.assertThat((Object)GUSTAVO_FRING, (Matcher)CoreMatchers.equalTo((Object)this.runFlow("getDefaultEnemy").getMessage().getPayload().getValue()));
    }

    @Test
    public void operationWithDefaulValueParameterLong() throws Exception {
        MatcherAssert.assertThat((Object)GUSTAVO_FRING, (Matcher)CoreMatchers.equalTo((Object)this.runFlow("getDefaultEnemyLong").getMessage().getPayload().getValue()));
    }

    @Test
    public void operationWhichReturnsListOfMessages() throws Exception {
        TypedValue payload = this.runFlow("getAllEnemies").getMessage().getPayload();
        MatcherAssert.assertThat((Object)payload.getDataType(), (Matcher)Matchers.is((Matcher)DataTypeCompatibilityMatcher.assignableTo((DataType)DataType.MULE_MESSAGE_COLLECTION)));
        List enemies = (List)payload.getValue();
        HeisenbergExtension heisenberg = this.getConfig(HEISENBERG);
        MatcherAssert.assertThat((Object)enemies, (Matcher)Matchers.hasSize((int)heisenberg.getEnemies().size()));
        int index = 0;
        for (Message enemyMessage : enemies) {
            this.assertEnemyMessage(heisenberg, index, enemyMessage);
            ++index;
        }
    }

    private void assertEnemyMessage(HeisenbergExtension heisenberg, int index, Message enemyMessage) {
        MatcherAssert.assertThat((Object)enemyMessage.getPayload().getValue(), (Matcher)Matchers.is(heisenberg.getEnemies().get(index)));
        MatcherAssert.assertThat((Object)enemyMessage.getAttributes().getValue(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(IntegerAttributes.class)));
        MatcherAssert.assertThat((Object)((IntegerAttributes)enemyMessage.getAttributes().getValue()).getValue(), (Matcher)Matchers.is((Object)index));
    }

    @Test
    public void randomAccessOnOperationWhichReturnsListOfMessages() throws Exception {
        List enemies = (List)this.runFlow("getAllEnemies").getMessage().getPayload().getValue();
        HeisenbergExtension heisenberg = this.getConfig(HEISENBERG);
        MatcherAssert.assertThat((Object)enemies, (Matcher)Matchers.hasSize((int)heisenberg.getEnemies().size()));
        int index = enemies.size() - 1;
        this.assertEnemyMessage(heisenberg, index, (Message)enemies.get(index));
        index = 0;
        this.assertEnemyMessage(heisenberg, index, (Message)enemies.get(index));
    }

    @Test
    public void operationWithDynamicParameter() throws Exception {
        this.doTestExpressionEnemy(0);
    }

    @Test
    public void operationWithTransformedParameter() throws Exception {
        this.doTestExpressionEnemy("0");
    }

    @Test
    public void parameterFixedAtPayload() throws Exception {
        this.assertKillByPayload("killFromPayload");
    }

    @Test
    public void optionalParameterDefaultingToPayload() throws Exception {
        this.assertKillByPayload("customKillWithDefault");
    }

    @Test
    public void optionalParameterWithDefaultOverride() throws Exception {
        CoreEvent event = ((FlowRunner)((FlowRunner)((FlowRunner)this.flowRunner("customKillWithoutDefault").withPayload((Object)EMPTY_STRING)).withVariable("goodbye", (Object)GOODBYE_MESSAGE)).withVariable("victim", (Object)VICTIM)).run();
        this.assertKillPayload(event);
    }

    @Test
    public void getInjectedDependency() throws Exception {
        ExtensionManager extensionManager = (ExtensionManager)this.runFlow("injectedExtensionManager").getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)extensionManager, (Matcher)Matchers.is((Matcher)CoreMatchers.sameInstance((Object)muleContext.getExtensionManager())));
    }

    @Test
    public void alias() throws Exception {
        String alias = (String)this.runFlow("alias").getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)alias, (Matcher)Matchers.is((Object)"Howdy!, my name is Walter White and I'm 52 years old"));
    }

    @Test
    public void operationWithStaticInlinePojoParameter() throws Exception {
        String response = this.getPayloadAsString(this.runFlow("knockStaticInlineDoor").getMessage());
        this.assertKnockedDoor(response, "Inline Skyler");
    }

    @Test
    public void operationWithRequiredParameterButNullReturningExpression() throws Exception {
        Exception thrown = (Exception)Assert.assertThrows(Exception.class, () -> this.runFlow("knockWithNullDoor"));
        MatcherAssert.assertThat((Object)thrown, (Matcher)ThrowableRootCauseMatcher.hasRootCause((Matcher)Matchers.instanceOf(IllegalArgumentException.class)));
    }

    @Test
    public void operationWithDynamicInlinePojoParameter() throws Exception {
        this.assertDynamicDoor("knockDynamicInlineDoor");
    }

    @Test
    public void operationWithStaticTopLevelPojoParameter() throws Exception {
        String response = this.getPayloadAsString(this.runFlow("knockStaticTopLevelDoor").getMessage());
        this.assertKnockedDoor(response, "Top Level Skyler");
    }

    @Test
    public void operationWithDynamicTopLevelPojoParameter() throws Exception {
        this.assertDynamicDoor("knockDynamicTopLevelDoor");
    }

    @Test
    public void operationWithInlineListParameter() throws Exception {
        List response = (List)((FlowRunner)((FlowRunner)this.flowRunner("knockManyWithInlineList").withPayload((Object)EMPTY_STRING)).withVariable("victim", (Object)"Saul")).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.contains((Object[])new String[]{KnockeableDoor.knock((String)"Inline Skyler"), KnockeableDoor.knock((String)"Saul")}));
    }

    @Test
    public void operationWithExpressionListParameter() throws Exception {
        List<KnockeableDoor> doors = Arrays.asList(new KnockeableDoor(VICTIM), new KnockeableDoor("Saul"));
        List response = (List)((FlowRunner)((FlowRunner)this.flowRunner("knockManyByExpression").withPayload((Object)EMPTY_STRING)).withVariable("doors", doors)).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.contains((Object[])new String[]{KnockeableDoor.knock((String)VICTIM), KnockeableDoor.knock((String)"Saul")}));
    }

    @Test
    public void operationWhichRequiresConnection() throws Exception {
        MatcherAssert.assertThat((Object)this.getPayloadAsString(this.runFlow("callSaul").getMessage()), (Matcher)Matchers.is((Object)"You called 505-503-4455"));
    }

    @Test
    public void extensionWithExceptionEnricher() throws Throwable {
        ConnectionException thrown = (ConnectionException)Assert.assertThrows(ConnectionException.class, () -> this.runFlowAndThrowCause("callGus"));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)"Enriched Connection Exception: You are not allowed to speak with gus."));
    }

    @Test
    public void operationWithExceptionEnricher() throws Throwable {
        HeisenbergException thrown = (HeisenbergException)Assert.assertThrows(HeisenbergException.class, () -> this.runFlowAndThrowCause("cureCancer"));
        MatcherAssert.assertThat((Object)thrown.getCause(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(HealthException.class)));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)CoreMatchers.containsString((String)"Can't help you, you are going to die"));
    }

    private void runFlowAndThrowCause(String callGus) throws Throwable {
        throw this.flowRunner(callGus).runExpectingException().getCause();
    }

    @Test
    public void operationWhichConsumesANonInstantiableArgument() throws Exception {
        Ricin ricinWeapon = new Ricin();
        ricinWeapon.setMicrogramsPerKilo(10L);
        CoreEvent event = ((FlowRunner)((FlowRunner)this.flowRunner("killWithWeapon").withPayload((Object)EMPTY_STRING)).withVariable("weapon", (Object)ricinWeapon)).run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Matchers.is((Object)KILL_RESULT));
    }

    @Test
    public void connectionProviderDefaultValueSaulPhoneNumber() throws Exception {
        CoreEvent getSaulNumber = this.runFlow("getSaulNumber");
        MatcherAssert.assertThat((Object)getSaulNumber.getMessage().getPayload().getValue(), (Matcher)Matchers.is((Object)"505-503-4455"));
    }

    @Test
    public void operationWhichConsumesAListOfNonInstantiableArgument() throws Exception {
        Ricin ricinWeapon1 = new Ricin();
        ricinWeapon1.setMicrogramsPerKilo(10L);
        Ricin ricinWeapon2 = new Ricin();
        ricinWeapon2.setMicrogramsPerKilo(10L);
        List<Weapon> weaponList = Arrays.asList(ricinWeapon1, ricinWeapon2);
        CoreEvent event = ((FlowRunner)((FlowRunner)this.flowRunner("killWithMultipleWeapons").withPayload((Object)EMPTY_STRING)).withVariable("weapons", weaponList)).run();
        List result = weaponList.stream().map(Weapon::kill).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Matchers.is(result));
    }

    @Test
    public void operationWithListPojoAsDefaultPayload() throws Exception {
        Ricin ricinWeapon1 = new Ricin();
        ricinWeapon1.setMicrogramsPerKilo(20L);
        Ricin ricinWeapon2 = new Ricin();
        ricinWeapon2.setMicrogramsPerKilo(22L);
        List ricins = (List)((FlowRunner)this.flowRunner("killWithRicinDefaultPayload").withPayload(Arrays.asList(ricinWeapon1, ricinWeapon2))).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)ricins, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((Ricin)ricins.get(0)), (Matcher)Matchers.instanceOf(Ricin.class));
        MatcherAssert.assertThat((Object)((Ricin)ricins.get(1)), (Matcher)Matchers.instanceOf(Ricin.class));
        Ricin ricin1 = (Ricin)ricins.get(0);
        MatcherAssert.assertThat((Object)ricin1.getMicrogramsPerKilo(), (Matcher)Matchers.is((Object)20L));
        Ricin ricin2 = (Ricin)ricins.get(1);
        MatcherAssert.assertThat((Object)ricin2.getMicrogramsPerKilo(), (Matcher)Matchers.is((Object)22L));
    }

    @Test
    public void operationWithListPojoAsChildElementsOverridesDefault() throws Exception {
        List ricins = (List)((FlowRunner)this.flowRunner("killWithRicinAsChildElement").withPayload((Object)EMPTY_STRING)).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)ricins, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((Ricin)ricins.get(0)), (Matcher)Matchers.instanceOf(Ricin.class));
        MatcherAssert.assertThat((Object)((Ricin)ricins.get(1)), (Matcher)Matchers.instanceOf(Ricin.class));
        Ricin ricin1 = (Ricin)ricins.get(0);
        MatcherAssert.assertThat((Object)ricin1.getMicrogramsPerKilo(), (Matcher)Matchers.is((Object)20L));
        MatcherAssert.assertThat((Object)ricin1.getDestination().getVictim(), (Matcher)Matchers.is((Object)"Lidia"));
        MatcherAssert.assertThat((Object)ricin1.getDestination().getAddress(), (Matcher)Matchers.is((Object)"Stevia coffe shop"));
        Ricin ricin2 = (Ricin)ricins.get(1);
        MatcherAssert.assertThat((Object)ricin2.getMicrogramsPerKilo(), (Matcher)Matchers.is((Object)22L));
        MatcherAssert.assertThat((Object)ricin2.getDestination().getVictim(), (Matcher)Matchers.is((Object)GUSTAVO_FRING));
        MatcherAssert.assertThat((Object)ricin2.getDestination().getAddress(), (Matcher)Matchers.is((Object)"pollos hermanos"));
    }

    @Test
    public void operationWithParameterResolver() throws Exception {
        Object value = ((FlowRunner)this.flowRunner("literalEcho").withPayload((Object)EMPTY_STRING)).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.equalTo((Object)"#[money]"));
    }

    @Test
    public void getMedicalHistory() throws Exception {
        Map getMedicalHistory = (Map)this.flowRunner("getMedicalHistory").run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)getMedicalHistory, (Matcher)Matchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)getMedicalHistory.entrySet().size(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)((HealthStatus)getMedicalHistory.get("2013")), (Matcher)Matchers.is((Object)HealthStatus.HEALTHY));
        MatcherAssert.assertThat((Object)((HealthStatus)getMedicalHistory.get("2014")), (Matcher)Matchers.is((Object)HealthStatus.CANCER));
        MatcherAssert.assertThat((Object)((HealthStatus)getMedicalHistory.get("2015")), (Matcher)Matchers.is((Object)HealthStatus.DEAD));
    }

    @Test
    public void getGramsInStorage() throws Exception {
        int[][] gramsInStorage = (int[][])((FlowRunner)this.flowRunner("getGramsInStorage").withPayload((Object)new int[][]{{0, 22}, {1, 10}, {2, 30}})).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)gramsInStorage[0][0], (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)gramsInStorage[0][1], (Matcher)Matchers.is((Object)22));
        MatcherAssert.assertThat((Object)gramsInStorage[1][0], (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)gramsInStorage[1][1], (Matcher)Matchers.is((Object)10));
        MatcherAssert.assertThat((Object)gramsInStorage[2][0], (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)gramsInStorage[2][1], (Matcher)Matchers.is((Object)30));
    }

    @Test
    public void abstractParameterWithSubtypesAndParameterGroup() throws Exception {
        Investment investment = (Investment)this.flowRunner("investment").run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)investment, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(CarWash.class)));
        CarWash carWash = (CarWash)investment;
        MatcherAssert.assertThat((Object)carWash.getCommercialName(), (Matcher)Matchers.is((Object)"A1"));
        MatcherAssert.assertThat((Object)carWash.getInvestmentInfo(), (Matcher)Matchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)carWash.getInvestmentInfo().getValuation(), (Matcher)CoreMatchers.equalTo((Object)100L));
        MatcherAssert.assertThat((Object)carWash.getCarsPerMinute(), (Matcher)Matchers.is((Object)5));
        MatcherAssert.assertThat((Object)carWash.isApproved(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)carWash.getInvestmentSpinOffs(), (Matcher)Matchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)((Investment)carWash.getInvestmentSpinOffs().get("other-car-wash")), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(CarWash.class)));
        CarWash spinOff = (CarWash)carWash.getInvestmentSpinOffs().get("other-car-wash");
        MatcherAssert.assertThat((Object)spinOff.getCommercialName(), (Matcher)Matchers.is((Object)"B1"));
        MatcherAssert.assertThat((Object)spinOff.getInvestmentInfo(), (Matcher)Matchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)spinOff.getInvestmentInfo().getValuation(), (Matcher)CoreMatchers.equalTo((Object)10L));
        MatcherAssert.assertThat((Object)spinOff.getCarsPerMinute(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)spinOff.getDiscardedInvestments(), (Matcher)Matchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)spinOff.getDiscardedInvestments().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((Investment)spinOff.getDiscardedInvestments().get(0)), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(CarDealer.class)));
        CarDealer discarded = (CarDealer)spinOff.getDiscardedInvestments().get(0);
        MatcherAssert.assertThat((Object)discarded.getCommercialName(), (Matcher)Matchers.is((Object)"Premium Cars"));
        MatcherAssert.assertThat((Object)discarded.getCarStock(), (Matcher)Matchers.is((Object)50));
        MatcherAssert.assertThat((Object)discarded.getInvestmentInfo(), (Matcher)Matchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)discarded.getInvestmentInfo().getValuation(), (Matcher)CoreMatchers.equalTo((Object)666L));
        MatcherAssert.assertThat((Object)discarded.getInvestmentInfo().getInvestmentPlanB(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(CarDealer.class)));
        CarDealer planB = (CarDealer)discarded.getInvestmentInfo().getInvestmentPlanB();
        MatcherAssert.assertThat((Object)planB.getCommercialName(), (Matcher)Matchers.is((Object)"Not So Premium Cars"));
        MatcherAssert.assertThat((Object)planB.getCarStock(), (Matcher)Matchers.is((Object)5));
        MatcherAssert.assertThat((Object)planB.getInvestmentInfo(), (Matcher)Matchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)planB.getInvestmentInfo().getValuation(), (Matcher)CoreMatchers.equalTo((Object)333L));
    }

    @Test
    public void operationWithMapOfComplexType() throws Exception {
        String dean = "Dean";
        Map salesInfo = (Map)this.flowRunner("processSale").run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)salesInfo, (Matcher)IsMapContaining.hasKey((Object)"Dean"));
        SaleInfo saleInfo = (SaleInfo)salesInfo.get("Dean");
        MatcherAssert.assertThat((Object)saleInfo.getAmount(), (Matcher)Matchers.is((Object)500));
        MatcherAssert.assertThat((Object)saleInfo.getDetails(), (Matcher)Matchers.is((Object)"Some detail"));
    }

    @Test
    public void listOfMapsAsParameter() throws Exception {
        String expectedMessage = "an Apple";
        ArrayList listOfMaps = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(Apple.class.getSimpleName(), expectedMessage);
        listOfMaps.add(map);
        CoreEvent event = ((FlowRunner)this.flowRunner("eatComplexListOfMaps").withPayload(listOfMaps)).run();
        List result = (List)event.getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((String)((Map)result.get(0)).get(Apple.class.getSimpleName())), (Matcher)Matchers.is((Object)expectedMessage));
    }

    @Test
    public void operationWithInputStreamContentParameterInParameterGroup() throws Exception {
        String theMessage = "This is an important message";
        Object result = ((FlowRunner)this.flowRunner("operationWithInputStreamContentParam").withVariable("msg", (Object)new ByteArrayInputStream(theMessage.getBytes()))).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)theMessage));
    }

    @Test
    public void executeOperationWithExtensionsClient() throws Exception {
        String result = (String)this.flowRunner("withClient").run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)"ADIOS, Juani"));
    }

    @Test
    public void operationWithAliasedParametersAsChild() throws Exception {
        Map value = (Map)this.flowRunner("operationWithAliasedParametersAsChild").run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.is((Matcher)IsMapContaining.hasEntry((Matcher)Matchers.is((Object)"SomeName"), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(Ricin.class)))));
    }

    @Test
    public void operationWithAliasedParametersAsReference() throws Exception {
        Map value = (Map)this.flowRunner("operationWithAliasedParametersAsChild").run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.is((Matcher)IsMapContaining.hasEntry((Matcher)Matchers.is((Object)"SomeName"), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(Ricin.class)))));
    }

    @Test
    public void aliasedOperation() throws Exception {
        ParameterResolver result = (ParameterResolver)this.flowRunner("aliasedOperation").run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)((String)result.resolve()), (Matcher)Matchers.is((Object)"an expression"));
    }

    @Test
    public void anyTypeAsParameterType() throws Exception {
        TypedValue payload = this.flowRunner("receiveJsonInputStream").keepStreamsOpen().run().getMessage().getPayload();
        String jsonValue = OperationExecutionTestCase.cursorStreamToString((CursorStreamProvider)payload.getValue());
        MatcherAssert.assertThat((Object)jsonValue, (Matcher)Matchers.is((Object)"{\n  \n}"));
    }

    private void assertDynamicDoor(String flowName) throws Exception {
        this.assertDynamicVictim(flowName, VICTIM);
        this.assertDynamicVictim(flowName, "Saul");
    }

    private void assertDynamicVictim(String flowName, String victim) throws Exception {
        this.assertKnockedDoor(this.getPayloadAsString(((FlowRunner)((FlowRunner)this.flowRunner(flowName).withPayload((Object)EMPTY_STRING)).withVariable("victim", (Object)victim)).run().getMessage()), victim);
    }

    private void assertKnockedDoor(String actual, String expected) {
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Object)KnockeableDoor.knock((String)expected)));
    }

    private void assertKillPayload(CoreEvent event) throws MuleException {
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Matchers.is((Object)String.format("%s, %s", GOODBYE_MESSAGE, VICTIM)));
    }

    private void assertKillByPayload(String flowName) throws Exception {
        this.assertKillPayload(((FlowRunner)((FlowRunner)this.flowRunner(flowName).withPayload((Object)VICTIM)).withVariable("goodbye", (Object)GOODBYE_MESSAGE)).run());
    }

    private void doTestExpressionEnemy(Object enemyIndex) throws Exception {
        CoreEvent event = ((FlowRunner)((FlowRunner)this.flowRunner("expressionEnemy").withPayload((Object)EMPTY_STRING)).withVariable("enemy", enemyIndex)).run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Matchers.is((Object)GUSTAVO_FRING));
    }

    private HeisenbergExtension getConfig(String name) throws Exception {
        return (HeisenbergExtension)ExtensionsTestUtils.getConfigurationFromRegistry((String)name, (CoreEvent)CoreEvent.builder((CoreEvent)this.testEvent()).message(Message.of((Object)EMPTY_STRING)).build(), (MuleContext)muleContext);
    }

    private static String cursorStreamToString(CursorStreamProvider cursorStreamProvider) {
        String string;
        block8: {
            InputStream input = (InputStream)cursorStreamProvider.openCursor();
            try {
                string = IOUtils.toString((InputStream)input);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iox) {
                    throw new RuntimeException(iox);
                }
            }
            input.close();
        }
        return string;
    }
}

