/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.client.source;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.notification.CustomNotificationListener;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.NotificationListenerRegistry;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.extension.api.client.source.SourceResultHandler;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.test.module.extension.client.source.BaseExtensionClientSourceTestCase;

@Feature(value="Extensions Client")
@Story(value="Extension Client with Message sources")
public class ExtensionClientSourceWithResponseTestCase
extends BaseExtensionClientSourceTestCase {
    @Inject
    private NotificationListenerRegistry notificationListenerRegistry;
    @Inject
    private ExtensionManager extensionManager;
    private ClassLoader sourceCallbackContextClassLoader;
    private final Latch sourceCallbackContextClassLoaderLatch = new Latch();

    protected String[] getConfigFiles() {
        return new String[0];
    }

    protected void doSetUp() throws Exception {
        this.notificationListenerRegistry.registerListener((NotificationListener)((CustomNotificationListener)notification -> {
            if (notification.getAction().getActionId() == 100101) {
                this.sourceCallbackContextClassLoader = (ClassLoader)notification.getSource();
                this.sourceCallbackContextClassLoaderLatch.release();
            }
        }));
    }

    @Test
    public void sendSuccessfulResponse() throws Exception {
        Latch latch = new Latch();
        InputStream responseStream = (InputStream)Mockito.mock(InputStream.class);
        Consumer<SourceResultHandler> handlerConsumer = handler -> {
            String message;
            try {
                message = IOUtils.toString((InputStream)((InputStream)handler.getResult().getOutput()));
            }
            catch (IOException iox) {
                throw new RuntimeException(iox);
            }
            MatcherAssert.assertThat((Object)message, (Matcher)CoreMatchers.equalTo((Object)"We are the future. ... You have lived in the shadows of shame and fear for too long!"));
            handler.completeWithSuccess(params -> params.withParameter("body", (Object)responseStream)).whenComplete((v, e) -> latch.release());
        };
        this.handler = this.extensionsClient.createSource("Marvel", "MagnetoMutantSummon", handlerConsumer, parameters -> {});
        this.handler.start();
        MatcherAssert.assertThat((Object)latch.await(5L, TimeUnit.SECONDS), (Matcher)CoreMatchers.is((Object)true));
        ((InputStream)Mockito.verify((Object)responseStream)).read((byte[])ArgumentMatchers.any(byte[].class));
        this.assertSourceCallbackContextClassLoader();
    }

    @Test
    public void sendErrorResponse() throws Exception {
        Latch latch = new Latch();
        Reference capturedError = new Reference();
        String errorMessage = "Long Live Professor X";
        this.notificationListenerRegistry.registerListener((NotificationListener)((CustomNotificationListener)notification -> {
            if (notification.getAction().getActionId() == 100099) {
                capturedError.set((Object)((Error)notification.getSource()));
                latch.release();
            }
        }));
        Consumer<SourceResultHandler> handlerConsumer = handler -> {
            String message;
            try {
                message = IOUtils.toString((InputStream)((InputStream)handler.getResult().getOutput()));
            }
            catch (IOException iox) {
                throw new RuntimeException(iox);
            }
            MatcherAssert.assertThat((Object)message, (Matcher)CoreMatchers.equalTo((Object)"We are the future. ... You have lived in the shadows of shame and fear for too long!"));
            handler.completeWithError((Throwable)new RuntimeException("Long Live Professor X"), params -> {});
        };
        this.handler = this.extensionsClient.createSource("Marvel", "MagnetoMutantSummon", handlerConsumer, parameters -> {});
        this.handler.start();
        MatcherAssert.assertThat((Object)latch.await(5L, TimeUnit.SECONDS), (Matcher)CoreMatchers.is((Object)true));
        Error error = (Error)capturedError.get();
        MatcherAssert.assertThat((Object)error.getDescription(), (Matcher)CoreMatchers.equalTo((Object)"Long Live Professor X"));
        MatcherAssert.assertThat((Object)error.getErrorType().getIdentifier(), (Matcher)CoreMatchers.equalTo((Object)"UNKNOWN"));
        MatcherAssert.assertThat((Object)error.getErrorType().getNamespace(), (Matcher)CoreMatchers.equalTo((Object)"MULE"));
        this.assertSourceCallbackContextClassLoader();
    }

    private void assertSourceCallbackContextClassLoader() throws Exception {
        ExtensionModel marvelModel = (ExtensionModel)this.extensionManager.getExtension("Marvel").get();
        MatcherAssert.assertThat((Object)this.sourceCallbackContextClassLoaderLatch.await(5L, TimeUnit.SECONDS), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.sourceCallbackContextClassLoader, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)((ClassLoader)ExtensionModelUtils.getExtensionClassLoader((ExtensionModel)marvelModel).get()))));
    }
}

