/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.inject;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableWithSize;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;
import org.mule.functional.junit4.AbstractArtifactAstTestCase;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.api.value.ValueResult;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.module.extension.api.runtime.config.ConfigurationProviderFactory;
import org.mule.runtime.module.extension.api.runtime.config.ExtensionDesignTimeResolversFactory;
import org.mule.runtime.module.extension.internal.runtime.config.DefaultConfigurationProviderFactory;
import org.mule.runtime.module.extension.internal.runtime.config.DefaultExtensionDesignTimeResolversFactory;
import org.mule.sdk.api.data.sample.SampleDataException;
import org.mule.test.javaxinject.JavaxInjectCompatibilityTestExtension;
import org.mule.test.module.extension.data.sample.SampleDataExecutor;
import org.mule.test.module.extension.values.ValueProviderExecutor;

@Feature(value="Java SDK")
@Story(value="javax.inject compatibility")
public class JavaxInjectCompatibilityToolingTestCase
extends AbstractArtifactAstTestCase {
    private ExtensionModel javaxInjectExtension;
    private ExtensionDesignTimeResolversFactory extensionDesignTimeResolversFactory;
    private ConfigurationProviderFactory configurationProviderFactory;
    private SampleDataExecutor sampleDataExecutor;

    @Before
    public void createExtensionDesignTimeResolversFactory() throws InitialisationException {
        this.extensionDesignTimeResolversFactory = new DefaultExtensionDesignTimeResolversFactory();
        LifecycleUtils.initialiseIfNeeded((Object)this.extensionDesignTimeResolversFactory, (boolean)true, (MuleContext)muleContext);
        this.configurationProviderFactory = new DefaultConfigurationProviderFactory();
        LifecycleUtils.initialiseIfNeeded((Object)this.configurationProviderFactory, (boolean)true, (MuleContext)muleContext);
        this.sampleDataExecutor = new SampleDataExecutor(this.extensionDesignTimeResolversFactory);
    }

    protected String getConfigFile() {
        return "inject/javax-inject-compatibility-config.xml";
    }

    protected Set<ExtensionModel> getRequiredExtensions() {
        HashSet<ExtensionModel> extensions = new HashSet<ExtensionModel>();
        extensions.add(MuleExtensionModelProvider.getExtensionModel());
        this.javaxInjectExtension = this.loadExtension(JavaxInjectCompatibilityTestExtension.class, Collections.emptySet());
        extensions.add(this.javaxInjectExtension);
        return extensions;
    }

    @Test
    public void sampleData() throws SampleDataException {
        ComponentAst operationAst = this.getFlowComponent("operation", TypedComponentIdentifier.ComponentType.OPERATION);
        Message sampleData = (Message)this.sampleDataExecutor.getSampleData(this.javaxInjectExtension, MuleAstUtils.createComponentParameterizationFromComponentAst((ComponentAst)operationAst), Optional.empty()).getSampleData().orElseThrow();
        MatcherAssert.assertThat((Object)sampleData.getPayload().getValue(), (Matcher)Is.is((Object)Charset.defaultCharset().name()));
    }

    @Test
    public void valueProviders() {
        ComponentAst operationAst = this.getFlowComponent("valueProvider", TypedComponentIdentifier.ComponentType.OPERATION);
        ValueProviderExecutor valueProviderExecutor = new ValueProviderExecutor(this.extensionDesignTimeResolversFactory, (ParameterizedModel)operationAst.getModel(ParameterizedModel.class).orElseThrow());
        ComponentParameterization operationParameterization = MuleAstUtils.createComponentParameterizationFromComponentAst((ComponentAst)operationAst);
        ValueResult values = valueProviderExecutor.resolveValues(this.javaxInjectExtension, "param", operationParameterization, Optional.empty(), null);
        MatcherAssert.assertThat((Object)values.getValues(), (Matcher)IsIterableWithSize.iterableWithSize((int)1));
        MatcherAssert.assertThat((Object)((Value)values.getValues().iterator().next()).getId(), (Matcher)Is.is((Object)Charset.defaultCharset().name()));
    }
}

