/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.test.module.extension;

import static java.util.Arrays.asList;
import static java.util.Collections.singleton;
import static java.util.Collections.singletonMap;

import org.mule.test.heisenberg.extension.model.KnockeableDoor;
import org.mule.test.heisenberg.extension.model.Ricin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Base class for tests using heisenberg-config.xml configuration.
 */
public abstract class AbstractHeisenbergConfigTestCase extends AbstractExtensionFunctionalTestCase {

  @Override
  protected Map<String, Object> getStartUpRegistryObjects() {
    final Map<String, Object> objects = new HashMap<>();

    objects.put("recipes",
                Map.<String, Long>of("methylamine", 75l,
                                     "pseudoephedrine", 0l,
                                     "P2P", 25l));

    objects.put("deathsBySeasons",
                Map.<String, List<String>>of("s01", asList("emilio",
                                                           "domingo"),
                                             "s02", asList("tuco",
                                                           "tortuga")));

    Ricin ricin = new Ricin(new KnockeableDoor("Lidia", "Stevia coffe shop"), 22L);
    objects.put("labeledRicins",
                singletonMap("pojo", ricin));

    objects.put("monthlyIncomes",
                asList(12000L, 500L));

    objects.put("enemies",
                asList("Gustavo Fring", "Hank"));

    objects.put("ricinPacks",
                singleton(ricin));

    objects.put("candidateDoors",
                Map.<String, KnockeableDoor>of("skyler", new KnockeableDoor("Skyler", "308 Negra Arroyo Lane"),
                                               "saul", new KnockeableDoor("Saul", "Shopping Mall")));

    return objects;
  }
}
