/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.streaming;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsEmptyCollection;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.matchers.ThrowableCauseMatcher;
import org.mule.functional.junit4.matchers.ThrowableMessageMatcher;
import org.mule.runtime.api.exception.ComposedErrorException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextService;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.privileged.exception.MessagingException;
import org.mule.tck.junit4.matcher.Eventually;
import org.mule.tck.junit4.matcher.FunctionExpressionMatcher;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@Features(value={@Feature(value="Streaming"), @Feature(value="Fork/Join Strategies used by scatter-gather and parallel-foreach routers")})
@Story(value="Bytes Streaming")
@RunnerDelegateTo(value=Parameterized.class)
public class ScatterGatherTimeoutWithBytesStreamingExtensionTestCase
extends AbstractExtensionFunctionalTestCase {
    private static final String DATA = RandomStringUtils.insecure().nextAlphabetic(2048);
    @Inject
    private EventContextService eventContextService;
    @Rule
    public SystemProperty configName;

    @Parameterized.Parameters(name="config used: `{0}`")
    public static Iterable<String> configs() {
        return Arrays.asList("drStrange", "poolingDrStrange");
    }

    public ScatterGatherTimeoutWithBytesStreamingExtensionTestCase(String configName) {
        this.configName = new SystemProperty("configName", configName);
    }

    protected String getConfigFile() {
        return "streaming/scatter-gather-bytes-streaming-extension-config.xml";
    }

    @Test
    @Issue(value="W-16941297")
    @Description(value="A Scatter Gather router will time out while an operation is still executing. The operation then finishes and generates a stream which should eventually be closed.")
    public void whenScatterGatherTimesOutThenStreamsAreNotLeaked() throws InterruptedException {
        this.runScatterGatherFlowAndAwaitStreamClosed("scatterGatherWithTimeout");
        MatcherAssert.assertThat((Object)this.eventContextService, (Matcher)CoreMatchers.is((Matcher)Eventually.eventually((Matcher)FunctionExpressionMatcher.expressionMatches(EventContextService::getCurrentlyActiveFlowStacks, (Matcher)IsEmptyCollection.empty()))));
    }

    @Test
    @Issue(value="W-16941297")
    @Description(value="A Scatter Gather router with collect-list strategy will time out while an operation is still executing. The operation then finishes and generates a stream which should eventually be closed.")
    public void whenScatterGatherWithCollectListTimesOutThenStreamsAreNotLeaked() throws InterruptedException {
        this.runScatterGatherFlowAndAwaitStreamClosed("scatterGatherWithTimeoutCollectList");
        MatcherAssert.assertThat((Object)this.eventContextService, (Matcher)CoreMatchers.is((Matcher)Eventually.eventually((Matcher)FunctionExpressionMatcher.expressionMatches(EventContextService::getCurrentlyActiveFlowStacks, (Matcher)IsEmptyCollection.empty()))));
    }

    @Test
    @Issue(value="W-16941297")
    @Description(value="A Scatter Gather router will time out while an operation inside a referenced flow is still executing. The operation then finishes and generates a stream which should eventually be closed.")
    public void whenScatterGatherWithFlowRefTimesOutThenStreamsAreNotLeaked() throws InterruptedException {
        this.runScatterGatherFlowAndAwaitStreamClosed("scatterGatherWithTimeoutFlowRef");
        MatcherAssert.assertThat((Object)this.eventContextService, (Matcher)CoreMatchers.is((Matcher)Eventually.eventually((Matcher)FunctionExpressionMatcher.expressionMatches(EventContextService::getCurrentlyActiveFlowStacks, (Matcher)IsEmptyCollection.empty()))));
    }

    @Test
    @Issue(value="W-16941297")
    @Description(value="A Scatter Gather router will time out while an operation inside another nested Scatter Gather is still executing. The operation then finishes and generates a stream which should eventually be closed.")
    public void whenScatterGatherWithNestedTimesOutThenStreamsAreNotLeaked() throws InterruptedException {
        this.runScatterGatherFlowAndAwaitStreamClosed("scatterGatherWithNestedRoute");
        MatcherAssert.assertThat((Object)this.eventContextService, (Matcher)CoreMatchers.is((Matcher)Eventually.eventually((Matcher)FunctionExpressionMatcher.expressionMatches(EventContextService::getCurrentlyActiveFlowStacks, (Matcher)IsEmptyCollection.empty()))));
    }

    @Test
    @Issue(value="W-16941297")
    public void scatterGatherTimeoutStress() throws InterruptedException, ExecutionException {
        String flowName = "scatterGatherWithTimeout";
        this.runScatterGatherFlowAndAwaitStreamClosed(flowName);
        ExecutorService executorService = Executors.newFixedThreadPool(3);
        ArrayList futures = new ArrayList();
        for (int i = 0; i < 10; ++i) {
            futures.add(executorService.submit(() -> {
                try {
                    this.runScatterGatherFlowAndAwaitStreamClosed(flowName);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }));
        }
        for (Future future : futures) {
            future.get();
        }
        executorService.shutdown();
        MatcherAssert.assertThat((Object)executorService.awaitTermination(10L, TimeUnit.SECONDS), (Matcher)CoreMatchers.is((Object)true));
        this.runScatterGatherFlowAndAwaitStreamClosed(flowName);
        this.runScatterGatherFlowAndAwaitStreamClosed(flowName);
        MatcherAssert.assertThat((Object)this.eventContextService, (Matcher)CoreMatchers.is((Matcher)Eventually.eventually((Matcher)FunctionExpressionMatcher.expressionMatches(EventContextService::getCurrentlyActiveFlowStacks, (Matcher)IsEmptyCollection.empty())).atMostIn(20, TimeUnit.SECONDS)));
    }

    private void runScatterGatherFlowAndAwaitStreamClosed(String flowName) throws InterruptedException {
        CountDownLatch sgTimedOutLatch = new CountDownLatch(1);
        CountDownLatch pagingProviderClosedLatch = new CountDownLatch(1);
        MessagingException e = (MessagingException)Assert.assertThrows(MessagingException.class, () -> ((FlowRunner)((FlowRunner)((FlowRunner)this.flowRunner(flowName).withPayload(Collections.singletonList(DATA))).withVariable("latch", (Object)sgTimedOutLatch)).withVariable("providerClosedLatch", (Object)pagingProviderClosedLatch)).run());
        MatcherAssert.assertThat((Object)e, (Matcher)ThrowableCauseMatcher.hasCause((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Is.isA(ComposedErrorException.class), ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Route 1: java.util.concurrent.TimeoutException: Timeout while processing route/part: '1'"))})));
        sgTimedOutLatch.countDown();
        pagingProviderClosedLatch.await();
    }

    protected boolean isGracefulShutdown() {
        return true;
    }

    public static class AssertPayloadIsIteratorProvider
    implements Processor {
        public CoreEvent process(CoreEvent event) throws MuleException {
            MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(CursorIteratorProvider.class));
            return event;
        }
    }
}

