/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.transaction;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.extension.api.tx.OperationTransactionalAction;
import org.mule.sdk.api.tx.SourceTransactionalAction;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.runner.RunnerDelegateTo;
import org.mule.test.transactional.TransactionalSourceWithTXParameters;

@RunnerDelegateTo(value=Parameterized.class)
public class TransactionalActionParameterTestCase
extends AbstractExtensionFunctionalTestCase {
    private boolean isSdkApi;
    private final String configFile;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> configs() {
        return Arrays.asList({"tx/transactional-parameters-injection-config.xml", false}, {"tx/transactional-xa-parameters-injection-config.xml", true});
    }

    public TransactionalActionParameterTestCase(String configFile, boolean isSdkApi) {
        this.isSdkApi = isSdkApi;
        this.configFile = configFile;
    }

    protected String getConfigFile() {
        return this.configFile;
    }

    @Test
    public void injectAlwaysBeginSourceTransactionalAction() throws Exception {
        Reference sdkSourceTransactionalAction = new Reference();
        Reference sourceTransactionalAction = new Reference();
        if (this.isSdkApi) {
            org.mule.test.transactionalxa.TransactionalSourceWithTXParameters.responseCallback = tx -> sdkSourceTransactionalAction.set((Object)((SourceTransactionalAction)tx));
        } else {
            TransactionalSourceWithTXParameters.responseCallback = tx -> sourceTransactionalAction.set((Object)((org.mule.runtime.extension.api.tx.SourceTransactionalAction)tx));
        }
        this.startFlow("alwaysBeginTxAction");
        if (this.isSdkApi) {
            MatcherAssert.assertThat((Object)((SourceTransactionalAction)sdkSourceTransactionalAction.get()), (Matcher)Is.is((Object)SourceTransactionalAction.ALWAYS_BEGIN));
        } else {
            MatcherAssert.assertThat((Object)((org.mule.runtime.extension.api.tx.SourceTransactionalAction)sourceTransactionalAction.get()), (Matcher)Is.is((Object)org.mule.runtime.extension.api.tx.SourceTransactionalAction.ALWAYS_BEGIN));
        }
    }

    @Test
    public void injectDefaultOperationTransactionalAction() throws Exception {
        Enum value = (Enum)this.flowRunner("injectInOperationDefaultValue").run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)value.name(), (Matcher)Is.is((Object)OperationTransactionalAction.JOIN_IF_POSSIBLE.name()));
    }

    @Test
    public void injectInOperationJoinNotSupported() throws Exception {
        Enum value = (Enum)this.flowRunner("injectInOperationJoinNotSupported").run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)value.name(), (Matcher)Is.is((Object)OperationTransactionalAction.NOT_SUPPORTED.name()));
    }

    private void startFlow(String flowName) throws Exception {
        ((Flow)this.getFlowConstruct(flowName)).start();
    }
}

