/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.client.operation;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.runtime.extension.api.client.OperationParameterizer;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.test.module.extension.client.operation.ExtensionsClientTestCase;

@Feature(value="Extensions Client")
@Story(value="Blocking Extension Client")
public class BlockingExtensionsClientTestCase
extends ExtensionsClientTestCase {
    @Override
    protected <T, A> Result<T, A> doExecute(String extension, String operation, Optional<String> configName, Map<String, Object> params, boolean isPagedOperation, boolean supportsStreaming) throws Throwable {
        try {
            return (Result)this.client.execute(extension, operation, parameterizer -> {
                configName.ifPresent(arg_0 -> ((OperationParameterizer)parameterizer).withConfigRef(arg_0));
                params.forEach((arg_0, arg_1) -> ((OperationParameterizer)parameterizer).withParameter(arg_0, arg_1));
                if (isPagedOperation) {
                    parameterizer.withDefaultRepeatableIterables();
                } else if (supportsStreaming) {
                    parameterizer.withDefaultRepeatableStreaming();
                }
            }).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failure. The test threw an exception: " + e.getMessage(), e);
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    @Test
    public void executeNonRepeatablePagedOperation() throws Throwable {
        Result result = (Result)this.client.execute("Heisenberg", "getPagedBlocklist", params -> params.withConfigRef("heisenberg")).get();
        AtomicInteger count = new AtomicInteger(0);
        ((Iterator)result.getOutput()).forEachRemaining(m -> count.addAndGet(1));
        MatcherAssert.assertThat((Object)count.get(), (Matcher)CoreMatchers.is((Object)6));
    }

    @Test
    public void executeNonRepeatableInputStreamOperation() throws Throwable {
        Result result = (Result)this.client.execute("Heisenberg", "nameAsStream", params -> params.withConfigRef("heisenberg")).get();
        String value = IOUtils.toString((InputStream)((InputStream)result.getOutput()));
        try {
            MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.equalTo((Object)"Heisenberg"));
        }
        finally {
            IOUtils.closeQuietly((InputStream)((InputStream)result.getOutput()));
        }
    }

    @Test
    public void executeOperationWithInternalParameterGroup() throws Throwable {
        String message = "Skyler cheated on you";
        Result result = (Result)this.client.execute("Heisenberg", "whisperSecret", params -> ((OperationParameterizer)params.withConfigRef("heisenberg")).withParameter("internalGroup", "secret", (Object)"Skyler cheated on you")).get();
        MatcherAssert.assertThat((Object)((String)result.getOutput()), (Matcher)CoreMatchers.equalTo((Object)"Skyler cheated on you"));
    }
}

