/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.config;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.Kiwi;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public class ConfigLevelOperationTestCase
extends AbstractExtensionFunctionalTestCase {
    private final Class<? extends Fruit> fruitType;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({Apple.class}, {Banana.class}, {Kiwi.class});
    }

    public ConfigLevelOperationTestCase(Class<? extends Fruit> fruitType) {
        this.fruitType = fruitType;
    }

    protected String getConfigFile() {
        return "operations/vegan-config.xml";
    }

    @Test
    public void execute() throws Exception {
        Fruit fruit = (Fruit)this.flowRunner(this.fruitType.getSimpleName().toLowerCase() + "Ok").run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat(fruit.getClass(), (Matcher)CoreMatchers.equalTo(this.fruitType));
        MatcherAssert.assertThat((Object)fruit.isBitten(), (Matcher)CoreMatchers.is((Object)true));
    }
}

