/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.connector;

import jakarta.xml.bind.DatatypeConverter;
import java.util.Calendar;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.petstore.extension.PetStoreClient;

public class PetStoreCachedConnectionWithDynamicParameterTestCase
extends AbstractExtensionFunctionalTestCase {
    public static final String FLOW_NAME = "getClient";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String DATE = "date";

    protected String getConfigFile() {
        return "petstore-dynamic-connection-cached-parameter.xml";
    }

    @Test
    public void getDynamicConnectionParametersOnCachedConnection() throws Exception {
        PetStoreClient client = (PetStoreClient)((FlowRunner)((FlowRunner)((FlowRunner)this.flowRunner(FLOW_NAME).withVariable(USERNAME, (Object)"john")).withVariable(PASSWORD, (Object)"doe")).withVariable(DATE, (Object)DatatypeConverter.parseDateTime((String)"2008-09-15T15:53:23+05:00").getTime())).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)client.getUsername(), (Matcher)Matchers.is((Object)"john"));
        MatcherAssert.assertThat((Object)client.getPassword(), (Matcher)Matchers.is((Object)"doe"));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(client.getOpeningDate());
        Assert.assertEquals((long)calendar.get(1), (long)2008L);
        Assert.assertEquals((long)(calendar.get(2) + 1), (long)9L);
        Assert.assertEquals((long)calendar.get(5), (long)15L);
        client = (PetStoreClient)((FlowRunner)((FlowRunner)((FlowRunner)this.flowRunner(FLOW_NAME).withVariable(USERNAME, (Object)"john")).withVariable(PASSWORD, (Object)"doe")).withVariable(DATE, (Object)DatatypeConverter.parseDateTime((String)"2017-02-10").getTime())).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)client.getUsername(), (Matcher)Matchers.is((Object)"john"));
        MatcherAssert.assertThat((Object)client.getPassword(), (Matcher)Matchers.is((Object)"doe"));
        calendar.setTime(client.getOpeningDate());
        Assert.assertEquals((long)calendar.get(1), (long)2017L);
        Assert.assertEquals((long)(calendar.get(2) + 1), (long)2L);
        Assert.assertEquals((long)calendar.get(5), (long)10L);
    }
}

