/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.data.sample;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.meta.model.parameter.ActingParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.api.sampledata.SampleDataFailure;
import org.mule.runtime.api.sampledata.SampleDataResult;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.internal.util.ClassUtils;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.extension.api.property.ClassLoaderModelProperty;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.module.extension.api.runtime.config.ExtensionDesignTimeResolversFactory;
import org.mule.runtime.module.extension.api.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.api.tooling.sampledata.SampleDataProviderMediator;
import org.mule.sdk.api.data.sample.SampleDataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleDataExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SampleDataExecutor.class);
    private final ExtensionDesignTimeResolversFactory extensionDesignTimeResolversFactory;

    public SampleDataExecutor(ExtensionDesignTimeResolversFactory extensionDesignTimeResolversFactory) {
        this.extensionDesignTimeResolversFactory = extensionDesignTimeResolversFactory;
    }

    public SampleDataResult getSampleData(ExtensionModel extensionModel, ComponentParameterization parameters, Optional<ConfigurationProvider> configurationProvider) {
        try {
            ClassLoader extensionClassLoader = SampleDataExecutor.getClassLoader(extensionModel);
            return (SampleDataResult)ClassUtils.withContextClassLoader((ClassLoader)extensionClassLoader, () -> {
                if (!(parameters.getModel() instanceof ComponentModel) || !(parameters.getModel() instanceof HasOutputModel)) {
                    String message = String.format("Component '%s' does not support Sample Data", parameters.getModel().getName());
                    return SampleDataResult.resultFrom((SampleDataFailure)SampleDataFailure.Builder.newFailure().withMessage(message).withReason(message).withFailureCode("NOT_SUPPORTED").build());
                }
                ComponentModel componentModel = (ComponentModel)parameters.getModel();
                ComponentParameterization paramWithDefaultValues = this.getParametersWithDefaultValues(componentModel, parameters);
                ParameterValueResolver parameterValueResolver = this.extensionDesignTimeResolversFactory.createParameterValueResolver(paramWithDefaultValues, (ParameterizedModel)componentModel);
                SampleDataProviderMediator sampleDataProviderMediator = this.extensionDesignTimeResolversFactory.createSampleDataProviderMediator(extensionModel, componentModel, (Component)new NullComponent(extensionModel.getName(), componentModel.getName()), null);
                return SampleDataResult.resultFrom((Message)sampleDataProviderMediator.getSampleData(parameterValueResolver, configurationProvider.map(this::connectionSupplier).orElse(() -> null), configurationProvider.map(this::configSupplier).orElse(() -> null), () -> null));
            }, SampleDataException.class, e -> {
                throw new MuleRuntimeException((Throwable)e);
            });
        }
        catch (SampleDataException e2) {
            LOGGER.warn(String.format("Get sample data has FAILED with code: %s for component: %s", e2.getFailureCode(), parameters.getModel().getName()), (Throwable)e2);
            return SampleDataResult.resultFrom((SampleDataFailure)SampleDataFailure.Builder.newFailure((Throwable)e2).withFailureCode(e2.getFailureCode()).build());
        }
        catch (MuleRuntimeException e3) {
            Throwable cause = e3.getCause();
            if (cause instanceof SampleDataException) {
                SampleDataException sampleDataException = (SampleDataException)cause;
                LOGGER.warn(String.format("Get sample data has FAILED with code: %s for component: %s", sampleDataException.getFailureCode(), parameters.getModel().getName()), (Throwable)e3);
                SampleDataFailure.Builder failureBuilder = SampleDataFailure.Builder.newFailure((Throwable)cause);
                failureBuilder.withFailureCode(sampleDataException.getFailureCode());
                return SampleDataResult.resultFrom((SampleDataFailure)failureBuilder.build());
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
        catch (Exception e4) {
            if (e4 instanceof RuntimeException) {
                throw e4;
            }
            throw new RuntimeException(e4);
        }
    }

    private ComponentParameterization getParametersWithDefaultValues(ComponentModel componentModel, ComponentParameterization parameters) {
        return ((HasOutputModel)componentModel).getSampleDataProviderModel().map(model -> {
            List actingParameters = model.getParameters().stream().map(ActingParameterModel::getName).collect(Collectors.toList());
            List<Pair> defaultValues = componentModel.getParameterGroupModels().stream().flatMap(group -> group.getParameterModels().stream().filter(p -> actingParameters.contains(p.getName()) && parameters.getParameter(group.getName(), p.getName()) == null && !p.isRequired() && p.getDefaultValue() != null).map(p -> new Pair(group, p))).collect(Collectors.toList());
            if (defaultValues.isEmpty()) {
                return parameters;
            }
            ComponentParameterization.Builder parametersWithDefaultValues = ComponentParameterization.builder((ParameterizedModel)parameters.getModel());
            parameters.forEachParameter((group, param, value) -> parametersWithDefaultValues.withParameter(param.getName(), value));
            defaultValues.forEach(value -> parametersWithDefaultValues.withParameter(((ParameterGroupModel)value.getFirst()).getName(), ((ParameterModel)value.getSecond()).getName(), ((ParameterModel)value.getSecond()).getDefaultValue()));
            return parametersWithDefaultValues.build();
        }).orElse(parameters);
    }

    private Supplier<Object> configSupplier(ConfigurationProvider configurationProvider) {
        return () -> configurationProvider.get(null).getValue();
    }

    private <C> Supplier<C> connectionSupplier(ConfigurationProvider configurationProvider) {
        return () -> configurationProvider.get(null).getConnectionProvider().map(cp -> {
            try {
                return cp.connect();
            }
            catch (ConnectionException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }).orElse(null);
    }

    public static ClassLoader getClassLoader(ExtensionModel extensionModel) {
        return extensionModel.getModelProperty(ClassLoaderModelProperty.class).map(ClassLoaderModelProperty::getClassLoader).orElse(Thread.currentThread().getContextClassLoader());
    }

    private static class NullComponent
    extends AbstractComponent {
        private final ComponentLocation location;

        public NullComponent(String extensionName, String componentName) {
            this.location = DefaultComponentLocation.from((String)(extensionName + "/" + componentName));
        }

        public ComponentLocation getLocation() {
            return this.location;
        }

        public Location getRootContainerLocation() {
            return Location.builder().globalName(this.location.getLocation()).build();
        }
    }
}

