/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.transaction;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.matchers.ThrowableMessageMatcher;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.transaction.TransactionStatusException;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.runner.RunnerDelegateTo;
import org.mule.test.transactional.TransactionalOperations;

@RunnerDelegateTo(value=Parameterized.class)
public class TransactionalOperationTestCase
extends AbstractExtensionFunctionalTestCase {
    private final String configFile;

    @Parameterized.Parameters(name="{0}")
    public static Collection<String> configs() {
        return Arrays.asList("tx/transaction-config.xml", "tx/transaction-xa-config.xml");
    }

    public TransactionalOperationTestCase(String configFile) {
        this.configFile = configFile;
    }

    protected String getConfigFile() {
        return this.configFile;
    }

    @Test
    public void commited() throws Exception {
        ((FlowRunner)this.flowRunner("commitLocalTx").withPayload((Object)"")).run();
    }

    @Test
    public void rolledBack() throws Exception {
        ((FlowRunner)this.flowRunner("rollbackLocalTx").withPayload((Object)"")).run();
    }

    @Test
    public void executeTransactionless() throws Exception {
        Map result = (Map)((FlowRunner)this.flowRunner("executeTransactionless").withPayload((Object)"")).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)((Boolean)result.get("transactionBegun")), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)((Boolean)result.get("transactionCommited")), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)((Boolean)result.get("transactionRolledback")), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void localTxDoesntSupportMultipleResources() throws Exception {
        this.flowRunner("localTxDoesntSupportMultipleResources").runExpectingException(Matchers.allOf((Matcher)CoreMatchers.instanceOf(TransactionException.class), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"the current transaction doesn't support it and could not be bound"))));
    }

    @Test
    public void localTxSupportsMultipleOperationsFromSameResource() throws Exception {
        this.flowRunner("localTxSupportsMultipleOperationsFromSameResource").run();
    }

    @Test
    public void pagedOperationInTx() throws Exception {
        CoreEvent event = this.flowRunner("pagedOperationInTx").run();
        Collection accumulator = (Collection)((TypedValue)event.getVariables().get("accumulator")).getValue();
        MatcherAssert.assertThat((Object)accumulator, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)accumulator, (Matcher)Matchers.hasSize((int)2));
        Iterator it = accumulator.iterator();
        Integer id1 = (Integer)it.next();
        Integer id2 = (Integer)it.next();
        MatcherAssert.assertThat((Object)id1, (Matcher)CoreMatchers.equalTo((Object)id2));
    }

    @Test
    public void pagedOperationInTxAlwaysUsesSameConnection() throws Exception {
        CoreEvent event = this.flowRunner("pagedOperationInTxAlwaysUsesSameConnection").run();
        List connections = (List)((TypedValue)event.getVariables().get("connections")).getValue();
        MatcherAssert.assertThat((Object)connections, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)connections, (Matcher)Matchers.hasSize((int)2));
        Object connection = connections.get(0);
        MatcherAssert.assertThat((Object)connections.stream().allMatch(c -> c == connection), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void pagedOperationWithoutTx() throws Exception {
        CoreEvent event = this.flowRunner("pagedOperationWithoutTx").run();
        Collection accumulator = (Collection)((TypedValue)event.getVariables().get("accumulator")).getValue();
        MatcherAssert.assertThat((Object)accumulator, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)accumulator, (Matcher)Matchers.hasSize((int)2));
        Iterator it = accumulator.iterator();
        Integer id1 = (Integer)it.next();
        Integer id2 = (Integer)it.next();
        MatcherAssert.assertThat((Object)id1, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)id2)));
    }

    @Test
    public void doNotReconnectPagedOperationInTx() throws Exception {
        this.resetCounters();
        FlowRunner failingPagedOperationInTx = (FlowRunner)this.flowRunner("failingPagedOperationInTx").withVariable("failOn", (Object)1);
        Exception thrown = (Exception)Assertions.assertThrows(Exception.class, () -> failingPagedOperationInTx.run());
        MatcherAssert.assertThat((Object)thrown.getCause(), (Matcher)CoreMatchers.instanceOf(ConnectionException.class));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)CoreMatchers.containsString((String)"Failed to retrieve Page"));
    }

    @Test
    public void doNotReconnectStickyPagedOperationInTx() throws Exception {
        this.resetCounters();
        FlowRunner stickyFailingPagedOperationInTx = (FlowRunner)this.flowRunner("stickyFailingPagedOperationInTx").withVariable("failOn", (Object)1);
        Exception thrown = (Exception)Assertions.assertThrows(Exception.class, () -> stickyFailingPagedOperationInTx.run());
        MatcherAssert.assertThat((Object)thrown.getCause(), (Matcher)CoreMatchers.instanceOf(ConnectionException.class));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)CoreMatchers.containsString((String)"Failed to retrieve Page"));
    }

    @Test
    @Ignore(value="MULE-19198")
    public void doNotReconnectPagedOperationInTxWhenConnectionExceptionOnSecondPage() throws Exception {
        this.resetCounters();
        FlowRunner failingPagedOperationInTx = (FlowRunner)this.flowRunner("failingPagedOperationInTx").withVariable("failOn", (Object)2);
        Exception thrown = (Exception)Assertions.assertThrows(Exception.class, () -> failingPagedOperationInTx.run());
        MatcherAssert.assertThat((Object)thrown.getCause(), (Matcher)CoreMatchers.instanceOf(ConnectionException.class));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)CoreMatchers.containsString((String)"Failed to retrieve Page"));
    }

    @Test
    @Ignore(value="MULE-19198")
    public void doNotReconnectStickyPagedOperationInTxWhenConnectionExceptionOnSecondPage() throws Exception {
        this.resetCounters();
        FlowRunner stickyFailingPagedOperationInTx = (FlowRunner)this.flowRunner("stickyFailingPagedOperationInTx").withVariable("failOn", (Object)2);
        Exception thrown = (Exception)Assertions.assertThrows(Exception.class, () -> stickyFailingPagedOperationInTx.run());
        MatcherAssert.assertThat((Object)thrown.getCause(), (Matcher)CoreMatchers.instanceOf(ConnectionException.class));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)CoreMatchers.containsString((String)"Failed to retrieve Page"));
    }

    @Test
    public void doReconnectPagedOperationWithoutTx() throws Exception {
        this.resetCounters();
        CoreEvent event = ((FlowRunner)this.flowRunner("failingPagedOperationWithoutTx").withVariable("failOn", (Object)1)).run();
        Collection accumulator = (Collection)((TypedValue)event.getVariables().get("accumulator")).getValue();
        MatcherAssert.assertThat((Object)accumulator, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)accumulator, (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    public void doReconnectStickyPagedOperationWithoutTx() throws Exception {
        this.resetCounters();
        CoreEvent event = ((FlowRunner)this.flowRunner("stickyFailingPagedOperationWithoutTx").withVariable("failOn", (Object)1)).run();
        Collection accumulator = (Collection)((TypedValue)event.getVariables().get("accumulator")).getValue();
        MatcherAssert.assertThat((Object)accumulator, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)accumulator, (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    public void doReconnectPagedOperationWithoutTxWhenConnectionExceptionOnSecondPage() throws Exception {
        this.resetCounters();
        CoreEvent event = ((FlowRunner)this.flowRunner("failingPagedOperationWithoutTx").withVariable("failOn", (Object)2)).run();
        Collection accumulator = (Collection)((TypedValue)event.getVariables().get("accumulator")).getValue();
        MatcherAssert.assertThat((Object)accumulator, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)accumulator, (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    @Ignore(value="MULE-19198")
    public void doNotReconnectStickyPagedOperationWithoutTxWhenConnectionExceptionOnSecondPage() throws Exception {
        this.resetCounters();
        FlowRunner stickyFailingPagedOperationInTx = (FlowRunner)this.flowRunner("stickyFailingPagedOperationInTx").withVariable("failOn", (Object)2);
        Exception thrown = (Exception)Assertions.assertThrows(Exception.class, () -> stickyFailingPagedOperationInTx.run());
        MatcherAssert.assertThat((Object)thrown.getCause(), (Matcher)CoreMatchers.instanceOf(ConnectionException.class));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)CoreMatchers.containsString((String)"Failed to retrieve Page"));
    }

    @Test
    public void cantNestTransactions() throws Exception {
        FlowRunner cantNestTransactions = this.flowRunner("cantNestTransactions");
        Exception thrown = (Exception)Assertions.assertThrows(Exception.class, () -> cantNestTransactions.run());
        MatcherAssert.assertThat((Object)thrown.getCause(), (Matcher)CoreMatchers.instanceOf(TransactionStatusException.class));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)CoreMatchers.containsString((String)"Non-XA transactions can't be nested."));
    }

    @Test
    public void operationJoinsAlreadyCreatedTx() throws Exception {
        this.flowRunner("operationJoinsAlreadyCreatedTx").run();
    }

    @Test
    public void doNotRetryOnTxReconnection() throws Exception {
        FlowRunner doNotRetryOnTxReconnection = this.flowRunner("doNotRetryOnTxReconnection");
        Exception thrown = (Exception)Assertions.assertThrows(Exception.class, () -> doNotRetryOnTxReconnection.run());
        MatcherAssert.assertThat((Object)thrown.getCause(), (Matcher)CoreMatchers.instanceOf(ConnectionException.class));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)CoreMatchers.is((Object)"1"));
    }

    private void resetCounters() {
        TransactionalOperations.getPageCalls = 0;
        org.mule.test.transactionalxa.TransactionalOperations.getPageCalls = 0;
    }
}

