/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.values;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsIterableContaining;
import org.junit.Before;
import org.mule.functional.junit4.AbstractArtifactAstTestCase;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.api.value.ValueResult;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.values.ValueResolvingException;
import org.mule.runtime.module.extension.api.runtime.config.ConfigurationProviderFactory;
import org.mule.runtime.module.extension.api.runtime.config.ExtensionDesignTimeResolversFactory;
import org.mule.runtime.module.extension.internal.runtime.config.DefaultConfigurationProviderFactory;
import org.mule.runtime.module.extension.internal.runtime.config.DefaultExtensionDesignTimeResolversFactory;
import org.mule.tck.junit4.matcher.ValueMatcher;
import org.mule.tck.junit4.matcher.value.ValueResultSuccessMatcher;
import org.mule.test.module.extension.data.sample.SampleDataExecutor;
import org.mule.test.module.extension.values.ValueProviderExecutor;
import org.mule.test.values.extension.ValuesExtension;

@Feature(value="SDK Tooling Support")
@Story(value="Value Providers Service")
public abstract class AbstractValuesTestCase
extends AbstractArtifactAstTestCase {
    private ExtensionModel valuesExtension;
    private ExtensionDesignTimeResolversFactory extensionDesignTimeResolversFactory;
    private ConfigurationProviderFactory configurationProviderFactory;

    @Before
    public void createExtensionDesignTimeResolversFactory() throws InitialisationException {
        this.extensionDesignTimeResolversFactory = new DefaultExtensionDesignTimeResolversFactory();
        LifecycleUtils.initialiseIfNeeded((Object)this.extensionDesignTimeResolversFactory, (boolean)true, (MuleContext)muleContext);
        this.configurationProviderFactory = new DefaultConfigurationProviderFactory();
        LifecycleUtils.initialiseIfNeeded((Object)this.configurationProviderFactory, (boolean)true, (MuleContext)muleContext);
    }

    protected Set<ExtensionModel> getRequiredExtensions() {
        HashSet<ExtensionModel> extensions = new HashSet<ExtensionModel>();
        extensions.add(MuleExtensionModelProvider.getExtensionModel());
        this.valuesExtension = this.loadExtension(ValuesExtension.class, Collections.emptySet());
        extensions.add(this.valuesExtension);
        return extensions;
    }

    protected Matcher<Iterable<Value>> hasValues(String ... values) {
        Set<ValueMatcher> options = Arrays.stream(values).map(ValueMatcher::valueWithId).collect(Collectors.toSet());
        return this.hasValues(options.toArray(new ValueMatcher[0]));
    }

    protected Matcher<Iterable<Value>> hasValues(ValueMatcher ... valuesMatchers) {
        return IsIterableContaining.hasItems((Matcher[])valuesMatchers);
    }

    protected Set<Value> getValuesFromSource(String flowName, String parameterName) throws Exception {
        ComponentAst sourceAst = this.getFlowComponent(flowName, TypedComponentIdentifier.ComponentType.SOURCE);
        Optional<ConfigurationProvider> configurationProvider = this.configNameFromComponent(sourceAst).map(this::createConfigurationProvider);
        ValueProviderExecutor valueProviderExecutor = new ValueProviderExecutor(this.extensionDesignTimeResolversFactory, (ParameterizedModel)sourceAst.getModel(ParameterizedModel.class).orElseThrow());
        ComponentParameterization sourceParameterization = MuleAstUtils.createComponentParameterizationFromComponentAst((ComponentAst)sourceAst);
        ValueResult valueResult = valueProviderExecutor.resolveValues(this.valuesExtension, parameterName, sourceParameterization, configurationProvider, null);
        MatcherAssert.assertThat((Object)valueResult, (Matcher)ValueResultSuccessMatcher.isSuccess());
        return valueResult.getValues();
    }

    protected Set<Value> getValuesFromSource(String flowName, String parameterName, String targetSelector) throws Exception {
        ComponentAst sourceAst = this.getFlowComponent(flowName, TypedComponentIdentifier.ComponentType.SOURCE);
        Optional<ConfigurationProvider> configurationProvider = this.configNameFromComponent(sourceAst).map(this::createConfigurationProvider);
        ValueProviderExecutor valueProviderExecutor = new ValueProviderExecutor(this.extensionDesignTimeResolversFactory, (ParameterizedModel)sourceAst.getModel(ParameterizedModel.class).orElseThrow());
        ComponentParameterization sourceParameterization = MuleAstUtils.createComponentParameterizationFromComponentAst((ComponentAst)sourceAst);
        ValueResult valueResult = valueProviderExecutor.resolveValues(this.valuesExtension, parameterName, sourceParameterization, configurationProvider, targetSelector);
        MatcherAssert.assertThat((Object)valueResult, (Matcher)ValueResultSuccessMatcher.isSuccess());
        return valueResult.getValues();
    }

    protected Set<Value> getValues(String flowName, String parameterName) throws Exception {
        return this.checkResultAndRetrieveValues(this.getValueResult(flowName, parameterName));
    }

    protected ValueResult getValueResult(String flowName, String parameterName) throws Exception {
        ComponentAst operationAst = this.getFlowComponent(flowName, TypedComponentIdentifier.ComponentType.OPERATION);
        Optional<ConfigurationProvider> configurationProvider = this.configNameFromComponent(operationAst).map(this::createConfigurationProvider);
        ValueProviderExecutor valueProviderExecutor = new ValueProviderExecutor(this.extensionDesignTimeResolversFactory, (ParameterizedModel)operationAst.getModel(ParameterizedModel.class).orElseThrow());
        ComponentParameterization operationParameterization = MuleAstUtils.createComponentParameterizationFromComponentAst((ComponentAst)operationAst);
        return valueProviderExecutor.resolveValues(this.valuesExtension, parameterName, operationParameterization, configurationProvider, null);
    }

    protected Set<Value> getValues(String flowName, String parameterName, String targetSelector) throws Exception {
        return this.checkResultAndRetrieveValues(this.getValueResult(flowName, parameterName, targetSelector));
    }

    protected ValueResult getValueResult(String flowName, String parameterName, String targetSelector) throws Exception {
        ComponentAst operationAst = this.getFlowComponent(flowName, TypedComponentIdentifier.ComponentType.OPERATION);
        Optional<ConfigurationProvider> configurationProvider = this.configNameFromComponent(operationAst).map(this::createConfigurationProvider);
        ValueProviderExecutor valueProviderExecutor = new ValueProviderExecutor(this.extensionDesignTimeResolversFactory, (ParameterizedModel)operationAst.getModel(ParameterizedModel.class).orElseThrow());
        ComponentParameterization operationParameterization = MuleAstUtils.createComponentParameterizationFromComponentAst((ComponentAst)operationAst);
        return valueProviderExecutor.resolveValues(this.valuesExtension, parameterName, operationParameterization, configurationProvider, targetSelector);
    }

    protected Set<Value> getValuesFromConfig(String configName, String parameterName) throws Exception {
        return this.checkResultAndRetrieveValues(this.getValueResultFromConfig(configName, parameterName));
    }

    public ValueResult getValueResultFromConfig(String configName, String parameterName) {
        ComponentAst configAst = this.getTopLevelComponent(configName);
        ValueProviderExecutor valueProviderExecutor = new ValueProviderExecutor(this.extensionDesignTimeResolversFactory, (ParameterizedModel)configAst.getModel(ParameterizedModel.class).orElseThrow());
        ComponentParameterization configParameterization = MuleAstUtils.createComponentParameterizationFromComponentAst((ComponentAst)configAst);
        return valueProviderExecutor.resolveValues(this.valuesExtension, parameterName, configParameterization, Optional.empty(), null);
    }

    protected Set<Value> getFieldValuesFromConfig(String configName, String parameterName, String targetSelector) throws Exception {
        return this.checkResultAndRetrieveValues(this.getFieldValuesResultFromConfig(configName, parameterName, targetSelector));
    }

    public ValueResult getFieldValuesResultFromConfig(String configName, String parameterName, String targetSelector) {
        ComponentAst configAst = this.getTopLevelComponent(configName);
        ValueProviderExecutor valueProviderExecutor = new ValueProviderExecutor(this.extensionDesignTimeResolversFactory, (ParameterizedModel)configAst.getModel(ParameterizedModel.class).orElseThrow());
        ComponentParameterization configParameterization = MuleAstUtils.createComponentParameterizationFromComponentAst((ComponentAst)configAst);
        return valueProviderExecutor.resolveValues(this.valuesExtension, parameterName, configParameterization, Optional.empty(), targetSelector);
    }

    protected Set<Value> getValuesFromConnection(String configName, String parameterName) throws Exception {
        return this.checkResultAndRetrieveValues(this.getValueResultFromConnection(configName, parameterName));
    }

    public ValueResult getValueResultFromConnection(String configName, String parameterName) {
        ComponentAst connectionAst = this.getConnectionProvider(this.getTopLevelComponent(configName));
        ValueProviderExecutor valueProviderExecutor = new ValueProviderExecutor(this.extensionDesignTimeResolversFactory, (ParameterizedModel)connectionAst.getModel(ParameterizedModel.class).orElseThrow());
        ComponentParameterization conectionParameterization = MuleAstUtils.createComponentParameterizationFromComponentAst((ComponentAst)connectionAst);
        return valueProviderExecutor.resolveValues(this.valuesExtension, parameterName, conectionParameterization, Optional.empty(), null);
    }

    protected Set<Value> getFieldValuesFromConnection(String configName, String parameterName, String targetSelector) throws Exception {
        return this.checkResultAndRetrieveValues(this.getFieldValueResultFromConnection(configName, parameterName, targetSelector));
    }

    public ValueResult getFieldValueResultFromConnection(String configName, String parameterName, String targetSelector) {
        ComponentAst connectionAst = this.getConnectionProvider(this.getTopLevelComponent(configName));
        ValueProviderExecutor valueProviderExecutor = new ValueProviderExecutor(this.extensionDesignTimeResolversFactory, (ParameterizedModel)connectionAst.getModel(ParameterizedModel.class).orElseThrow());
        ComponentParameterization conectionParameterization = MuleAstUtils.createComponentParameterizationFromComponentAst((ComponentAst)connectionAst);
        return valueProviderExecutor.resolveValues(this.valuesExtension, parameterName, conectionParameterization, Optional.empty(), targetSelector);
    }

    private Set<Value> checkResultAndRetrieveValues(ValueResult values) throws ValueResolvingException {
        MatcherAssert.assertThat((Object)values, (Matcher)ValueResultSuccessMatcher.isSuccess());
        return values.getValues();
    }

    private ConfigurationProvider createConfigurationProvider(String configName) {
        ComponentAst configAst = this.getTopLevelComponent(configName);
        ComponentParameterization configParameterization = MuleAstUtils.createComponentParameterizationFromComponentAst((ComponentAst)configAst);
        return this.extensionDesignTimeResolversFactory.createConfigurationProvider(this.valuesExtension, (ConfigurationModel)configParameterization.getModel(), configName, configParameterization.getParameters().entrySet().stream().collect(Collectors.toMap(e -> ((ParameterModel)((Pair)e.getKey()).getSecond()).getName(), Map.Entry::getValue)), Optional.empty(), Optional.empty(), this.configurationProviderFactory, null, null, SampleDataExecutor.getClassLoader(this.valuesExtension));
    }
}

