/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.connector;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.petstore.extension.PetCage;

public class PetStoreComplexParameterTestCase
extends AbstractExtensionFunctionalTestCase {
    protected String getConfigFile() {
        return "petstore-complex-parameter.xml";
    }

    protected Map<String, Object> getStartUpRegistryObjects() {
        HashMap<String, Object> objects = new HashMap<String, Object>();
        objects.put("birds", Map.of("mockingjay", 15, "mockingbird", 10));
        objects.put("ammenities", Arrays.asList("spinning wheel", "food can"));
        return objects;
    }

    protected boolean isDisposeContextPerClass() {
        return true;
    }

    @Test
    public void configWithConfigReferences() throws Exception {
        PetCage cage = (PetCage)this.flowRunner("getCageWithReferences").run().getMessage().getPayload().getValue();
        this.assertBirds(cage.getBirds());
        this.assertAmmenities(cage.getAmmenities());
    }

    @Test
    public void configWithConfigMELReferences() throws Exception {
        PetCage cage = (PetCage)this.flowRunner("getCageWithMELReferences").run().getMessage().getPayload().getValue();
        this.assertBirds(cage.getBirds());
        this.assertAmmenities(cage.getAmmenities());
    }

    @Test
    public void configWithConfigChildElements() throws Exception {
        PetCage cage = (PetCage)this.flowRunner("getCageWithChildElements").run().getMessage().getPayload().getValue();
        this.assertBirds(cage.getBirds());
        this.assertAmmenities(cage.getAmmenities());
    }

    private void assertBirds(Map<String, Integer> birds) {
        Assert.assertNotNull(birds);
        MatcherAssert.assertThat((Object)birds.get("mockingjay"), (Matcher)CoreMatchers.equalTo((Object)15));
        MatcherAssert.assertThat((Object)birds.get("mockingbird"), (Matcher)CoreMatchers.equalTo((Object)10));
    }

    private void assertAmmenities(List<String> ammenities) {
        Assert.assertNotNull(ammenities);
        MatcherAssert.assertThat((Object)ammenities.get(0), (Matcher)CoreMatchers.equalTo((Object)"spinning wheel"));
        MatcherAssert.assertThat((Object)ammenities.get(1), (Matcher)CoreMatchers.equalTo((Object)"food can"));
    }
}

