/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.transaction;

import java.util.Arrays;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.util.func.CheckedSupplier;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.runner.RunnerDelegateTo;
import org.mule.test.transactional.SdkTransactionalSource;
import org.mule.test.transactional.connection.SdkTestTransactionalConnection;
import org.mule.test.transactional.connection.TestTransactionalConnection;
import org.mule.test.transactionalxa.TransactionalSource;

@RunnerDelegateTo(value=Parameterized.class)
public class TransactionalSourceTestCase
extends AbstractExtensionFunctionalTestCase {
    private final Supplier<Boolean> successSource;
    private final String configFile;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"Using Extensions API", () -> org.mule.test.transactional.TransactionalSource.isSuccess, "tx/source-transaction-config.xml"}, {"Using SDK API, legacy XA", () -> SdkTransactionalSource.isSuccess, "tx/sdk-source-transaction-config.xml"}, {"Using SDK API", () -> TransactionalSource.isSuccess, "tx/source-transaction-xa-config.xml"});
    }

    public TransactionalSourceTestCase(String parametrizationName, Supplier<Boolean> successSource, String configFile) {
        this.successSource = successSource;
        this.configFile = configFile;
    }

    protected String getConfigFile() {
        return this.configFile;
    }

    @Before
    public void setUp() throws Exception {
        MessageStorage.clean();
        org.mule.test.transactional.TransactionalSource.isSuccess = null;
        SdkTransactionalSource.isSuccess = null;
        TransactionalSource.isSuccess = null;
    }

    @After
    public void tearDown() {
        MessageStorage.clean();
        org.mule.test.transactional.TransactionalSource.isSuccess = null;
        SdkTransactionalSource.isSuccess = null;
        TransactionalSource.isSuccess = null;
    }

    @Test
    public void sourceStartsALocalTxAndGetsCommitted() throws Exception {
        this.startFlow("sourceStartsALocalTxAndGetsCommitted");
        this.validate((CheckedSupplier<Boolean>)((CheckedSupplier)() -> !MessageStorage.messages.isEmpty()));
        this.validateFlow(true);
        this.validateCommittedTransaction(MessageStorage.messages.poll());
    }

    @Test
    public void sourceStartsALocalTxAndGetsRollBacked() throws Exception {
        this.startFlow("sourceStartsALocalTxAndGetsRollBacked");
        this.validate((CheckedSupplier<Boolean>)((CheckedSupplier)() -> !MessageStorage.messages.isEmpty()));
        this.validateFlow(false);
        this.validateRolledBackedTransaction(MessageStorage.messages.poll());
    }

    @Test
    public void sourceStartsALocalTxAndOperationsCanJointIt() throws Exception {
        this.startFlow("sourceStartsALocalTxAndOperationsCanJointIt");
        this.validate((CheckedSupplier<Boolean>)((CheckedSupplier)() -> MessageStorage.messages.size() == 2));
        this.validateFlow(true);
        this.validateCommittedTransaction(MessageStorage.messages.peek());
    }

    @Test
    public void sourceStartsALocalTxAndOperationsWithDifferentConnectionCanTJoinIt() throws Exception {
        this.startFlow("sourceStartsALocalTxAndOperationsWithDifferentConnectionCanTJoinIt");
        this.validate((CheckedSupplier<Boolean>)((CheckedSupplier)() -> MessageStorage.exception != null));
        MatcherAssert.assertThat((Object)MessageStorage.exception, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(TransactionException.class)));
        this.validateFlow(false);
        this.validateRolledBackedTransaction(MessageStorage.messages.poll());
    }

    @Test
    public void nonTxSourceDoesntBeginTx() throws Exception {
        this.startFlow("nonTxSourceDoesntBeginTx");
        this.validate((CheckedSupplier<Boolean>)((CheckedSupplier)() -> !MessageStorage.messages.isEmpty()));
        this.validateFlow(true);
        this.validateNonTxConnection(MessageStorage.messages.poll());
    }

    @Test
    public void nonTxSourceWithNonTxOperation() throws Exception {
        this.startFlow("nonTxSourceWithNonTxOperation");
        this.validate((CheckedSupplier<Boolean>)((CheckedSupplier)() -> !MessageStorage.messages.isEmpty()));
        this.validateFlow(true);
        this.validateNonTxConnection(MessageStorage.messages.poll());
    }

    @Test
    public void nonTxSourceWithTxInside() throws Exception {
        this.startFlow("nonTxSourceWithTxInside");
        this.validate((CheckedSupplier<Boolean>)((CheckedSupplier)() -> !MessageStorage.messages.isEmpty()));
        this.validateFlow(true);
        this.validateNonTxConnection(MessageStorage.messages.poll());
    }

    @Test
    public void sourceWithTxAndTimeout() throws Exception {
        this.startFlow("sourceWithTimeout");
        this.validateFlow(false);
        this.validateRolledBackedTransaction(MessageStorage.messages.poll());
    }

    private void startFlow(String flowName) throws Exception {
        ((Flow)this.getFlowConstruct(flowName)).start();
    }

    private void validate(CheckedSupplier<Boolean> validation) {
        new PollingProber(10000L, 100L).check((Probe)new JUnitLambdaProbe(validation));
    }

    private void validateCommittedTransaction(Object connection) {
        this.assertTransactionConnectionState(connection, true, true, false);
    }

    private void validateRolledBackedTransaction(Object connection) {
        this.assertTransactionConnectionState(connection, true, false, true);
    }

    private void validateNonTxConnection(Object connection) {
        this.assertTransactionConnectionState(connection, false, false, false);
    }

    private void validateFlow(boolean succeeded) {
        this.validate((CheckedSupplier<Boolean>)((CheckedSupplier)() -> this.successSource.get() != null));
        MatcherAssert.assertThat((Object)this.successSource.get(), (Matcher)CoreMatchers.is((Object)succeeded));
    }

    private void assertTransactionConnectionState(Object connection, boolean begun, boolean committed, boolean rolledBack) {
        if (connection instanceof TestTransactionalConnection) {
            TestTransactionalConnection conn = (TestTransactionalConnection)connection;
            MatcherAssert.assertThat((Object)conn.isTransactionBegun(), (Matcher)CoreMatchers.is((Object)begun));
            MatcherAssert.assertThat((Object)conn.isTransactionCommited(), (Matcher)CoreMatchers.is((Object)committed));
            MatcherAssert.assertThat((Object)conn.isTransactionRolledback(), (Matcher)CoreMatchers.is((Object)rolledBack));
        } else if (connection instanceof SdkTestTransactionalConnection) {
            SdkTestTransactionalConnection conn = (SdkTestTransactionalConnection)connection;
            MatcherAssert.assertThat((Object)conn.isTransactionBegun(), (Matcher)CoreMatchers.is((Object)begun));
            MatcherAssert.assertThat((Object)conn.isTransactionCommited(), (Matcher)CoreMatchers.is((Object)committed));
            MatcherAssert.assertThat((Object)conn.isTransactionRolledback(), (Matcher)CoreMatchers.is((Object)rolledBack));
        } else if (connection instanceof org.mule.test.transactionalxa.connection.TestTransactionalConnection) {
            org.mule.test.transactionalxa.connection.TestTransactionalConnection conn = (org.mule.test.transactionalxa.connection.TestTransactionalConnection)connection;
            MatcherAssert.assertThat((Object)conn.isTransactionBegun(), (Matcher)CoreMatchers.is((Object)begun));
            MatcherAssert.assertThat((Object)conn.isTransactionCommited(), (Matcher)CoreMatchers.is((Object)committed));
            MatcherAssert.assertThat((Object)conn.isTransactionRolledback(), (Matcher)CoreMatchers.is((Object)rolledBack));
        } else {
            throw new RuntimeException("Stored object is not a valid type of connection");
        }
    }

    public static class MessageStorage
    extends AbstractComponent
    implements Processor {
        public static Queue<Object> messages = new ConcurrentLinkedQueue<Object>();
        public static Throwable exception;

        public CoreEvent process(CoreEvent event) throws MuleException {
            event.getError().ifPresent(theError -> {
                exception = theError.getCause();
            });
            TypedValue payload = event.getMessage().getPayload();
            if (payload.getValue() != null) {
                messages.add(payload.getValue());
            }
            return event;
        }

        public static void clean() {
            exception = null;
            messages = new ConcurrentLinkedQueue<Object>();
        }
    }

    public static class SleepProcessor
    implements Processor {
        public CoreEvent process(CoreEvent event) throws MuleException {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return event;
        }
    }
}

