/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.source;

import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.cluster.ClusterService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.builders.AbstractConfigurationBuilder;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
@Features(value={@Feature(value="Clustering"), @Feature(value="Sources")})
public class HeisenbergClusterSourceTestCase
extends AbstractExtensionFunctionalTestCase {
    @Parameterized.Parameter(value=0)
    public boolean primaryPollingInstance;
    private Flow flow;

    @Parameterized.Parameters(name="primaryPollingInstance: {0}")
    public static Collection<Boolean> params() {
        return Arrays.asList(false, true);
    }

    protected String getConfigFile() {
        return "source/heisenberg-cluster-source-config.xml";
    }

    @Before
    public void before() {
        HeisenbergExtension.sourceTimesStarted = 0;
    }

    protected void doTearDown() throws Exception {
        if (this.flow != null) {
            this.flow.stop();
        }
        super.doTearDown();
    }

    protected void addBuilders(List<ConfigurationBuilder> builders) {
        super.addBuilders(builders);
        builders.add((ConfigurationBuilder)new AbstractConfigurationBuilder(){

            protected void doConfigure(MuleContext muleContext) throws Exception {
                muleContext.getCustomizationService().overrideDefaultServiceImpl("_muleClusterService", (Object)new TestClusterService(HeisenbergClusterSourceTestCase.this.primaryPollingInstance));
            }
        });
    }

    @Test
    public void primaryNodeOnlyDefaultToTrue() throws Exception {
        this.startFlow("source-default");
        if (this.primaryPollingInstance) {
            MatcherAssert.assertThat((Object)HeisenbergExtension.sourceTimesStarted, (Matcher)CoreMatchers.is((Object)1));
        } else {
            MatcherAssert.assertThat((Object)HeisenbergExtension.sourceTimesStarted, (Matcher)CoreMatchers.is((Object)0));
        }
    }

    @Test
    public void primaryNodeOnlySetToTrue() throws Exception {
        this.startFlow("source-true");
        if (this.primaryPollingInstance) {
            MatcherAssert.assertThat((Object)HeisenbergExtension.sourceTimesStarted, (Matcher)CoreMatchers.is((Object)1));
        } else {
            MatcherAssert.assertThat((Object)HeisenbergExtension.sourceTimesStarted, (Matcher)CoreMatchers.is((Object)0));
        }
    }

    @Test
    public void primaryNodeOnlySetToFalse() throws Exception {
        this.startFlow("source-false");
        MatcherAssert.assertThat((Object)HeisenbergExtension.sourceTimesStarted, (Matcher)CoreMatchers.is((Object)1));
    }

    private void startFlow(String flowName) throws Exception {
        this.flow = (Flow)this.getFlowConstruct(flowName);
        this.flow.start();
    }

    private static class TestClusterService
    implements ClusterService {
        private final boolean primaryPollingInstance;

        public TestClusterService(boolean primaryPollingInstance) {
            this.primaryPollingInstance = primaryPollingInstance;
        }

        public boolean isPrimaryPollingInstance() {
            return this.primaryPollingInstance;
        }
    }
}

