/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.parameter.resolver;

import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.extension.api.runtime.parameter.ParameterResolver;
import org.mule.test.heisenberg.extension.model.Ricin;
import org.mule.test.heisenberg.extension.model.Weapon;
import org.mule.test.module.extension.parameter.resolver.AbstractParameterResolverTestCase;

public class ParameterResolverOperationExecutionTestCase
extends AbstractParameterResolverTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private static final Matcher<? super Weapon> WEAPON_MATCHER = CoreMatchers.allOf((Matcher)CoreMatchers.notNullValue(), (Matcher)CoreMatchers.instanceOf(Ricin.class), (Matcher)Matchers.hasProperty((String)"microgramsPerKilo", (Matcher)CoreMatchers.is((Object)100L)));

    protected String[] getConfigFiles() {
        return new String[]{"parameter-resolver-operation-config.xml"};
    }

    @Override
    protected boolean isDisposeContextPerClass() {
        return true;
    }

    @Test
    public void operationWithExpressionResolver() throws Exception {
        this.assertExpressionResolverWeapon("processWeapon", "#[payload]", WEAPON_MATCHER);
    }

    @Test
    public void operationWithExpressionResolverAsStaticChildElement() throws Exception {
        this.assertExpressionResolverWeapon("processWeaponAsStaticChildElement", null, WEAPON_MATCHER);
    }

    @Test
    public void operationWithExpressionResolverAsDynamicChildElement() throws Exception {
        this.assertExpressionResolverWeapon("processWeaponAsDynamicChildElement", null, WEAPON_MATCHER);
    }

    @Test
    public void parameterResolverWithDefaultValue() throws Exception {
        this.assertExpressionResolverWeapon("processWeaponWithDefaultValue", "#[payload]", WEAPON_MATCHER);
    }

    @Test
    public void operationWithExpressionResolverAndNullWeapon() throws Exception {
        this.assertExpressionResolverWeapon("processNullWeapon", null, CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void operationWithExpressionResolverNegative() throws Exception {
        this.expectedException.expect(ExpressionRuntimeException.class);
        ParameterResolver weapon = (ParameterResolver)this.flowRunner("processWrongWeapon").run().getMessage().getPayload().getValue();
        weapon.resolve();
    }

    @Test
    public void parameterResolverOfListOfComplexType() throws Exception {
        this.assertExpressionResolverWeapon("processWeaponList", "#[mel:payload]", CoreMatchers.allOf((Matcher)Matchers.hasSize((int)1), (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Weapon.class)))));
    }

    @Test
    public void parameterResolverOfListOfComplexTypeAsChild() throws Exception {
        this.assertExpressionResolverWeapon("processWeaponListAsChild", null, CoreMatchers.allOf((Matcher)Matchers.hasSize((int)2), (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Weapon.class)))));
    }

    @Test
    public void parameterResolverOfListOfSimpleType() throws Exception {
        this.assertExpressionResolverWeapon("processAddressBookAsExpression", "#[mel:['123-333-33','333-333-333']]", CoreMatchers.allOf((Matcher)Matchers.hasSize((int)2), (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(String.class)))));
    }

    @Test
    public void parameterResolverOfListOfSimpleTypeAsChild() throws Exception {
        this.assertExpressionResolverWeapon("processAddressBookAsChild", null, CoreMatchers.allOf((Matcher)Matchers.hasSize((int)2), (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(String.class)))));
    }

    private void assertExpressionResolverWeapon(String flowName, String expression, Matcher weaponMatcher) throws Exception {
        ParameterResolver weaponInfo = (ParameterResolver)this.flowRunner(flowName).run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)weaponInfo.getExpression(), (Matcher)CoreMatchers.is(Optional.ofNullable(expression)));
        Assert.assertThat((Object)weaponInfo.resolve(), (Matcher)weaponMatcher);
    }
}

