/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.reconnection;

import java.time.Duration;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.extension.test.extension.reconnection.ReconnectableConnection;
import org.mule.extension.test.extension.reconnection.ReconnectableConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.retry.policy.RetryPolicy;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.tck.probe.PollingProber;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class ReconnectionTestCase
extends AbstractExtensionFunctionalTestCase {
    private static List<CoreEvent> capturedEvents;

    protected String getConfigFile() {
        return "reconnection-config.xml";
    }

    protected void doSetUp() throws Exception {
        capturedEvents = new LinkedList<CoreEvent>();
        ReconnectableConnectionProvider.fail = false;
    }

    protected void doTearDown() throws Exception {
        capturedEvents = null;
        ReconnectableConnectionProvider.fail = false;
    }

    @Test
    public void reconnectSource() throws Exception {
        ((Startable)this.getFlowConstruct("reconnectForever")).start();
        PollingProber.check((long)5000L, (long)1000L, () -> !capturedEvents.isEmpty());
        this.switchConnection();
        PollingProber.check((long)10000L, (long)1000L, () -> {
            List<CoreEvent> list = capturedEvents;
            synchronized (list) {
                return capturedEvents.stream().map(event -> (ReconnectableConnection)event.getMessage().getPayload().getValue()).filter(c -> c.getReconnectionAttempts() >= 3).findAny().isPresent();
            }
        });
    }

    @Test
    public void getRetryPolicyTemplateFromConfig() throws Exception {
        RetryPolicyTemplate template = (RetryPolicyTemplate)this.flowRunner("getReconnectionFromConfig").run().getMessage().getPayload().getValue();
        this.assertRetryTemplate(template, false, 3, 1000L);
    }

    @Test
    public void getInlineRetryPolicyTemplate() throws Exception {
        RetryPolicyTemplate template = (RetryPolicyTemplate)this.flowRunner("getInlineReconnection").run().getMessage().getPayload().getValue();
        this.assertRetryTemplate(template, false, 30, 50L);
    }

    private void assertRetryTemplate(RetryPolicyTemplate template, boolean async, int count, long freq) throws Exception {
        Assert.assertThat((Object)template.isAsync(), (Matcher)CoreMatchers.is((Object)async));
        RetryPolicy policy = template.createRetryInstance();
        Assert.assertThat((Object)ClassUtils.getFieldValue((Object)policy, (String)"count", (boolean)false), (Matcher)CoreMatchers.is((Object)count));
        Duration duration = (Duration)ClassUtils.getFieldValue((Object)policy, (String)"frequency", (boolean)false);
        Assert.assertThat((Object)duration.toMillis(), (Matcher)CoreMatchers.is((Object)freq));
    }

    private void switchConnection() throws Exception {
        this.flowRunner("switchConnection").run();
    }

    public static class CaptureProcessor
    implements Processor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CoreEvent process(CoreEvent event) throws MuleException {
            List list = capturedEvents;
            synchronized (list) {
                capturedEvents.add(event);
            }
            return event;
        }
    }
}

