/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl.source;

import com.google.common.base.Joiner;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceCallbackModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.runtime.source.BackPressureMode;
import org.mule.runtime.module.extension.internal.config.dsl.AbstractExtensionObjectFactory;
import org.mule.runtime.module.extension.internal.loader.java.property.BackPressureStrategyModelProperty;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.runtime.source.ExtensionMessageSource;
import org.mule.runtime.module.extension.internal.runtime.source.SourceAdapterFactory;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionSourceObjectFactory
extends AbstractExtensionObjectFactory<ExtensionMessageSource> {
    private final Logger LOGGER = LoggerFactory.getLogger(ExtensionSourceObjectFactory.class);
    @Inject
    private ReflectionCache reflectionCache;
    private final ExtensionModel extensionModel;
    private final SourceModel sourceModel;
    private RetryPolicyTemplate retryPolicyTemplate;
    private CursorProviderFactory cursorProviderFactory;
    private Boolean primaryNodeOnly = null;
    private MessageSource.BackPressureStrategy backPressureStrategy = null;

    public ExtensionSourceObjectFactory(ExtensionModel extensionModel, SourceModel sourceModel, MuleContext muleContext) {
        super(muleContext);
        this.extensionModel = extensionModel;
        this.sourceModel = sourceModel;
    }

    public ExtensionMessageSource doGetObject() {
        return (ExtensionMessageSource)ClassUtils.withContextClassLoader((ClassLoader)MuleExtensionUtils.getClassLoader((ExtensionModel)this.extensionModel), () -> {
            this.getParametersResolver().checkParameterGroupExclusiveness(Optional.of(this.sourceModel), this.sourceModel.getParameterGroupModels(), this.parameters.keySet());
            ResolverSet nonCallbackParameters = this.getNonCallbackParameters();
            if (this.hasDynamicNonCallbackParameters(nonCallbackParameters)) {
                throw this.dynamicParameterException(nonCallbackParameters, this.sourceModel);
            }
            ResolverSet responseCallbackParameters = this.getCallbackParameters(this.sourceModel.getSuccessCallback());
            ResolverSet errorCallbackParameters = this.getCallbackParameters(this.sourceModel.getErrorCallback());
            LifecycleUtils.initialiseIfNeeded((Object)nonCallbackParameters, (boolean)true, (MuleContext)this.muleContext);
            LifecycleUtils.initialiseIfNeeded((Object)responseCallbackParameters, (boolean)true, (MuleContext)this.muleContext);
            LifecycleUtils.initialiseIfNeeded((Object)errorCallbackParameters, (boolean)true, (MuleContext)this.muleContext);
            MessageSource.BackPressureStrategy backPressureStrategy = this.getBackPressureStrategy();
            return new ExtensionMessageSource(this.extensionModel, this.sourceModel, this.getSourceAdapterFactory(nonCallbackParameters, responseCallbackParameters, errorCallbackParameters, backPressureStrategy), this.getConfigurationProvider(), this.calculatePrimaryNodeOnly(nonCallbackParameters).booleanValue(), this.getRetryPolicyTemplate(), this.cursorProviderFactory, backPressureStrategy, this.muleContext.getExtensionManager(), (NotificationDispatcher)((MuleContextWithRegistry)this.muleContext).getRegistry().lookupObject(NotificationDispatcher.class), this.muleContext.getTransactionFactoryManager(), this.muleContext.getConfiguration().getId());
        });
    }

    private Boolean calculatePrimaryNodeOnly(ResolverSet nonCallbackParameters) {
        if (this.sourceModel.runsOnPrimaryNodeOnly()) {
            return true;
        }
        try {
            ValueResolver primaryNodeOnlyValueResolver = (ValueResolver)nonCallbackParameters.getResolvers().get("primaryNodeOnly");
            return primaryNodeOnlyValueResolver == null ? false : (Boolean)primaryNodeOnlyValueResolver.resolve(ValueResolvingContext.builder((CoreEvent)org.mule.runtime.module.extension.api.util.MuleExtensionUtils.getInitialiserEvent()).build());
        }
        catch (MuleException e) {
            String errorMessage = String.format("There was a problem resolving the value of the %s parameter for the %s source.", "primaryNodeOnly", this.sourceModel.getName());
            this.LOGGER.error(errorMessage);
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)errorMessage), (Throwable)e);
        }
    }

    private boolean hasDynamicNonCallbackParameters(ResolverSet nonCallbackParameters) {
        return nonCallbackParameters.getResolvers().entrySet().stream().filter(e -> !"config-ref".equals(e.getKey())).anyMatch(e -> ((ValueResolver)e.getValue()).isDynamic());
    }

    private MessageSource.BackPressureStrategy getBackPressureStrategy() {
        if (this.backPressureStrategy != null) {
            return this.backPressureStrategy;
        }
        return this.sourceModel.getModelProperty(BackPressureStrategyModelProperty.class).map(p -> MuleExtensionUtils.toBackPressureStrategy((BackPressureMode)p.getDefaultMode())).orElse(MessageSource.BackPressureStrategy.WAIT);
    }

    private ResolverSet getNonCallbackParameters() throws ConfigurationException {
        return this.getParametersResolver().getParametersAsResolverSet(this.muleContext, (ParameterizedModel)this.sourceModel, this.sourceModel.getParameterGroupModels());
    }

    private ResolverSet getCallbackParameters(Optional<SourceCallbackModel> callbackModel) throws ConfigurationException {
        if (callbackModel.isPresent()) {
            return this.getParametersResolver().getParametersAsResolverSet((ParameterizedModel)callbackModel.get(), this.muleContext);
        }
        return new ResolverSet(this.muleContext);
    }

    private SourceAdapterFactory getSourceAdapterFactory(ResolverSet nonCallbackParameters, ResolverSet successCallbackParameters, ResolverSet errorCallbackParameters, MessageSource.BackPressureStrategy backPressureStrategy) {
        return new SourceAdapterFactory(this.extensionModel, this.sourceModel, nonCallbackParameters, successCallbackParameters, errorCallbackParameters, this.cursorProviderFactory, backPressureStrategy, this.reflectionCache, this.expressionManager, this.properties, this.muleContext);
    }

    private RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    private ConfigurationProvider getConfigurationProvider() {
        return this.parameters.values().stream().filter(v -> v instanceof ConfigurationProvider).map(v -> (ConfigurationProvider)v).findAny().orElse(null);
    }

    public void setRetryPolicyTemplate(RetryPolicyTemplate retryPolicyTemplate) {
        this.retryPolicyTemplate = retryPolicyTemplate;
    }

    private ConfigurationException dynamicParameterException(ResolverSet resolverSet, SourceModel model) {
        List dynamicParams = resolverSet.getResolvers().entrySet().stream().filter(entry -> ((ValueResolver)entry.getValue()).isDynamic()).map(Map.Entry::getKey).collect(Collectors.toList());
        String message = "The source: '" + model.getName() + "' is using expressions, which are not allowed on message sources. Offending parameters are: [" + Joiner.on((char)',').join(dynamicParams) + "]";
        return new ConfigurationException(I18nMessageFactory.createStaticMessage((String)message));
    }

    public void setCursorProviderFactory(CursorProviderFactory cursorProviderFactory) {
        this.cursorProviderFactory = cursorProviderFactory;
    }

    public void setPrimaryNodeOnly(Boolean primaryNodeOnly) {
        this.primaryNodeOnly = primaryNodeOnly;
    }

    public void setBackPressureStrategy(MessageSource.BackPressureStrategy backPressureStrategy) {
        this.backPressureStrategy = backPressureStrategy;
    }
}

