/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.metadata;

import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.tck.junit4.matcher.MetadataKeyMatcher;
import org.mule.tck.junit4.matcher.metadata.MetadataKeyResultSuccessMatcher;
import org.mule.tck.message.StringAttributes;
import org.mule.test.metadata.extension.MetadataConnectionProvider;
import org.mule.test.metadata.extension.MetadataSource;
import org.mule.test.module.extension.metadata.MetadataExtensionFunctionalTestCase;

public class SourceMetadataTestCase
extends MetadataExtensionFunctionalTestCase<SourceModel> {
    private static final String EXPECTED_STARTED_SOURCE_KEY_ID = String.format("Source Started = [%s]", false);
    private static final String EXPECTED_STARTED_CONNECTION_PROVIDER_KEY_ID = String.format("Connection Provider Started = [%s]", true);

    public SourceMetadataTestCase(MetadataExtensionFunctionalTestCase.ResolutionType resolutionType) {
        super(resolutionType);
        this.provider = resolutionType == MetadataExtensionFunctionalTestCase.ResolutionType.EXPLICIT_RESOLUTION ? MetadataService::getSourceMetadata : (metadataService, componentId, key) -> metadataService.getSourceMetadata(componentId);
        this.location = Location.builder().globalName("sourceMetadata").addSourcePart().build();
    }

    @Before
    public void before() {
        MetadataConnectionProvider.STARTED = false;
        MetadataSource.STARTED = false;
    }

    protected String getConfigFile() {
        return "metadata-tests.xml";
    }

    @Test
    public void getSourceMetadataKeys() {
        MetadataResult metadataKeysResult = this.metadataService.getMetadataKeys(this.location);
        MatcherAssert.assertThat((Object)metadataKeysResult, (Matcher)MetadataKeyResultSuccessMatcher.isSuccess());
        Set<MetadataKey> metadataKeys = this.getKeysFromContainer((MetadataKeysContainer)metadataKeysResult.get());
        MatcherAssert.assertThat((Object)metadataKeys.size(), (Matcher)CoreMatchers.is((Object)5));
        MatcherAssert.assertThat(metadataKeys, (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{MetadataKeyMatcher.metadataKeyWithId((String)"PERSON"), MetadataKeyMatcher.metadataKeyWithId((String)"CAR"), MetadataKeyMatcher.metadataKeyWithId((String)"HOUSE"), MetadataKeyMatcher.metadataKeyWithId((String)EXPECTED_STARTED_SOURCE_KEY_ID), MetadataKeyMatcher.metadataKeyWithId((String)EXPECTED_STARTED_CONNECTION_PROVIDER_KEY_ID)}));
    }

    @Test
    public void getSourceMetadataKeysMultiLevelShowInDsl() {
        Location location = Location.builder().globalName("sourceMetadataWithPartialMultiLevelShowInDsl").addSourcePart().build();
        MetadataResult metadataKeysResult = this.metadataService.getMetadataKeys(location);
        MatcherAssert.assertThat((Object)metadataKeysResult, (Matcher)MetadataKeyResultSuccessMatcher.isSuccess());
        Set<MetadataKey> continents = this.getKeysFromContainer((MetadataKeysContainer)metadataKeysResult.get());
        MatcherAssert.assertThat(continents, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat(continents, (Matcher)Matchers.hasItem((Matcher)MetadataKeyMatcher.metadataKeyWithId((String)"AMERICA").withDisplayName("AMERICA").withPartName("continent")));
        MatcherAssert.assertThat(continents, (Matcher)CoreMatchers.not((Matcher)Matchers.hasItem((Matcher)MetadataKeyMatcher.metadataKeyWithId((String)"EUROPE").withDisplayName("EUROPE").withPartName("continent"))));
    }

    @Test
    public void getSourceDynamicOutputMetadata() throws Exception {
        MetadataResult result = this.getComponentDynamicMetadata(PERSON_METADATA_KEY);
        MatcherAssert.assertThat(result, (Matcher)MetadataKeyResultSuccessMatcher.isSuccess());
        ComponentMetadataDescriptor componentMetadata = (ComponentMetadataDescriptor)result.get();
        this.assertExpectedOutput((ConnectableComponentModel)componentMetadata.getModel(), this.personType, this.typeLoader.load(StringAttributes.class));
        MatcherAssert.assertThat(componentMetadata.getMetadataAttributes().getKey().get(), (Matcher)CoreMatchers.is((Object)PERSON_METADATA_KEY));
    }

    @Test
    public void sourcesMustNotStartWhenResolvingMetadata() {
        MetadataResult metadataKeysResult = this.metadataService.getMetadataKeys(this.location);
        Set<MetadataKey> metadataKeys = this.getKeysFromContainer((MetadataKeysContainer)metadataKeysResult.get());
        MatcherAssert.assertThat(metadataKeys, (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{MetadataKeyMatcher.metadataKeyWithId((String)EXPECTED_STARTED_SOURCE_KEY_ID)}));
    }

    @Test
    public void sourcesMustStartConnectionProvidersWhenResolvingMetadata() {
        MetadataResult metadataKeysResult = this.metadataService.getMetadataKeys(this.location);
        Set<MetadataKey> metadataKeys = this.getKeysFromContainer((MetadataKeysContainer)metadataKeysResult.get());
        MatcherAssert.assertThat(metadataKeys, (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{MetadataKeyMatcher.metadataKeyWithId((String)EXPECTED_STARTED_CONNECTION_PROVIDER_KEY_ID)}));
    }
}

