/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.operation;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.test.vegan.extension.BananaConfig;

public class FlowListenerOperationExecutionTestCase
extends AbstractExtensionFunctionalTestCase {
    private BananaConfig config;

    protected String getConfigFile() {
        return "vegan-flow-listener-operation-config.xml";
    }

    protected void doSetUp() throws Exception {
        this.config = (BananaConfig)ExtensionsTestUtils.getConfigurationFromRegistry((String)"banana", (CoreEvent)this.testEvent(), (MuleContext)muleContext);
    }

    @Test
    public void listenSuccessfulFlow() throws Exception {
        Message message = this.flowRunner("listenAndByteBanana").run().getMessage();
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Banana.class)));
        Banana banana = (Banana)message.getPayload().getValue();
        this.check(() -> {
            Assert.assertThat((Object)banana.isPeeled(), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)banana.isBitten(), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)this.config.getBananasCount(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)this.config.getNonBananasCount(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)this.config.getExceptionCount(), (Matcher)CoreMatchers.is((Object)0));
        });
    }

    @Test
    public void listenSuccessfulFlowWithUnexpecteResult() throws Exception {
        Message message = this.flowRunner("listenAndEatMeat").run().getMessage();
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(Fruit.class))));
        this.check(() -> {
            Assert.assertThat((Object)this.config.getBananasCount(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)this.config.getNonBananasCount(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)this.config.getExceptionCount(), (Matcher)CoreMatchers.is((Object)0));
        });
    }

    @Test
    public void listenError() throws Exception {
        this.flowRunner("listenAndFail").runExpectingException();
        this.check(() -> Assert.assertThat((Object)this.config.getExceptionCount(), (Matcher)CoreMatchers.is((Object)1)));
    }

    private void check(Runnable probe) {
        PollingProber.check((long)5000L, (long)100L, () -> {
            probe.run();
            return true;
        });
    }
}

