/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.schema.doc;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Whitelist;
import org.mule.runtime.module.extension.internal.capability.xml.schema.doc.JavaDocModel;

public class JavaDocReader {
    private static final String PARAM = "@param";
    private static final String EMPTY = "";
    private static final char AT_CHAR = '@';
    private static final char NEW_LINE_CHAR = '\n';
    private static final char SPACE_CHAR = ' ';
    private static final char CLOSING_BRACKET_CHAR = '}';
    private static final char OPENING_BRACKET_CHAR = '{';
    private static final char LESS_THAN_CHAR = '<';
    private static final char GREATER_THAN_CHAR = '>';
    public static final Whitelist WHITELIST = Whitelist.none().addTags(new String[]{"a"}).addAttributes("a", new String[]{"href"}).addProtocols("a", "href", new String[]{"http", "https"});
    public static final Whitelist NONE = Whitelist.none();

    public static JavaDocModel parseJavaDoc(ProcessingEnvironment processingEnv, Element element) {
        String comment = JavaDocReader.extractJavadoc(processingEnv, element);
        ParsingState readingState = ParsingState.ON_BODY;
        StringBuilder body = new StringBuilder();
        HashMap<String, StringBuilder> params = new HashMap<String, StringBuilder>();
        String paramName = EMPTY;
        StringTokenizer st = new StringTokenizer(comment, "\n\r");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.isEmpty()) {
                switch (readingState) {
                    case ON_BODY: {
                        body.append('\n');
                        break;
                    }
                    case ON_PARAM: {
                        ((StringBuilder)params.get(paramName)).append('\n');
                        break;
                    }
                }
                continue;
            }
            if (token.startsWith(PARAM)) {
                readingState = ParsingState.ON_PARAM;
                paramName = JavaDocReader.parseParameter(token, params);
                continue;
            }
            if (token.charAt(0) != '@') {
                switch (readingState) {
                    case ON_BODY: {
                        body.append(' ').append(token);
                        break;
                    }
                    case ON_PARAM: {
                        ((StringBuilder)params.get(paramName)).append(' ').append(token);
                        break;
                    }
                }
                continue;
            }
            if (token.charAt(0) != '@') continue;
            readingState = ParsingState.UNSUPPORTED;
        }
        return new JavaDocModel(JavaDocReader.clean(body.toString()), params.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> JavaDocReader.clean(((StringBuilder)entry.getValue()).toString()))));
    }

    private static String parseParameter(String token, Map<String, StringBuilder> params) {
        String description;
        String currentParamName;
        StringBuilder paramBuilder = new StringBuilder();
        String param = token.replaceFirst(PARAM, EMPTY).trim();
        int descriptionIndex = param.indexOf(" ");
        if (descriptionIndex != -1) {
            currentParamName = param.substring(0, descriptionIndex).trim();
            description = param.substring(descriptionIndex).trim();
        } else {
            currentParamName = param;
            description = EMPTY;
        }
        paramBuilder.append(description);
        params.put(currentParamName, paramBuilder);
        return currentParamName;
    }

    private static String clean(String text) {
        return JavaDocReader.removeHTML(JavaDocReader.stripTags(text));
    }

    private static String removeHTML(String text) {
        String textWithAnchors = Jsoup.clean((String)text, (Whitelist)WHITELIST);
        Document htmlDoc = Jsoup.parseBodyFragment((String)textWithAnchors);
        for (org.jsoup.nodes.Element anchor : htmlDoc.select("a")) {
            anchor.html(anchor.attr("href") + "[" + anchor.html() + "]");
        }
        return Jsoup.clean((String)htmlDoc.html(), (Whitelist)NONE);
    }

    private static String stripTags(String comment) {
        if (StringUtils.isEmpty((CharSequence)comment)) {
            return comment;
        }
        StringBuilder builder = new StringBuilder();
        boolean insideTag = false;
        comment = comment.trim();
        int length = comment.length();
        for (int i = 0; i < length; ++i) {
            if (comment.charAt(i) == '{') {
                int nextCharIndex = i + 1;
                if (nextCharIndex < length && comment.charAt(nextCharIndex) == '@') {
                    while (comment.charAt(nextCharIndex) != ' ' && comment.charAt(nextCharIndex) != '}') {
                        nextCharIndex = i++;
                    }
                    insideTag = true;
                    i = nextCharIndex;
                    continue;
                }
            } else if (comment.charAt(i) == '}' && insideTag) {
                insideTag = false;
                continue;
            }
            if (comment.charAt(i) == '<' && insideTag) {
                builder.append("&lt;");
                continue;
            }
            if (comment.charAt(i) == '>' && insideTag) {
                builder.append("&gt;");
                continue;
            }
            builder.append(comment.charAt(i));
        }
        String strippedComments = builder.toString().trim();
        while (strippedComments.length() > 0 && strippedComments.charAt(strippedComments.length() - 1) == '\n') {
            strippedComments = StringUtils.chomp((String)strippedComments);
        }
        return strippedComments;
    }

    private static String extractJavadoc(ProcessingEnvironment processingEnv, Element element) {
        String comment = processingEnv.getElementUtils().getDocComment(element);
        if (StringUtils.isBlank((CharSequence)comment)) {
            return EMPTY;
        }
        return comment.trim();
    }

    public static enum ParsingState {
        ON_PARAM,
        ON_BODY,
        UNSUPPORTED;

    }
}

