/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.connector;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.api.streaming.bytes.InMemoryCursorStreamConfig;
import org.mule.runtime.core.api.streaming.bytes.InMemoryCursorStreamProvider;
import org.mule.tck.core.streaming.DummyByteBufferManager;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class PetStoreSerializableParameterTestCase
extends AbstractExtensionFunctionalTestCase {
    private static final String DONKEY = "donkey";

    protected String getConfigFile() {
        return "petstore-serializable-parameter.xml";
    }

    @Test
    public void staticSerializableParameter() throws Exception {
        Assert.assertThat((Object)this.flowRunner("staticSerializableParameter").run().getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)DONKEY));
    }

    @Test
    public void dynamicSerializableParameter() throws Exception {
        Message message = ((FlowRunner)this.flowRunner("dynamicSerializableParameter").withVariable("animal", (Object)DONKEY)).run().getMessage();
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)DONKEY));
    }

    @Test
    public void inputStreamParameter() throws Exception {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(DONKEY.getBytes());
        Message message = ((FlowRunner)this.flowRunner("dynamicSerializableParameter").withVariable("animal", (Object)inputStream)).run().getMessage();
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)DONKEY));
    }

    @Test
    public void cursorStreamProviderParameter() throws Exception {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(DONKEY.getBytes());
        InMemoryCursorStreamProvider provider = new InMemoryCursorStreamProvider((InputStream)inputStream, InMemoryCursorStreamConfig.getDefault(), (ByteBufferManager)new DummyByteBufferManager());
        Message message = ((FlowRunner)this.flowRunner("dynamicSerializableParameter").withVariable("animal", (Object)provider)).run().getMessage();
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)DONKEY));
    }
}

