/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.error;

import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.exception.ExpectedError;
import org.mule.runtime.api.exception.MuleException;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.util.TestConnectivityUtils;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class ErrorTypesResolutionTestCase
extends AbstractExtensionFunctionalTestCase {
    @Rule
    public SystemProperty connectivity = TestConnectivityUtils.disableAutomaticTestConnectivity();
    @Rule
    public DynamicPort port = new DynamicPort("port");
    @Rule
    public ExpectedError expectedError = ExpectedError.none();

    protected String getConfigFile() {
        return "error-types-resolution.xml";
    }

    @Test
    public void underlyingErrorIsRespected() throws Exception {
        this.expectedError.expectErrorType("MULE", "STREAM_MAXIMUM_SIZE_EXCEEDED");
        this.flowRunner("withUnderlyingConnectorError").run();
    }

    @Test
    public void failsWithoutUnderlyingError() throws Exception {
        this.expectedError.expectErrorType("PETSTORE", "PET_ERROR");
        this.flowRunner("withoutUnderlyingConnectorError").run();
    }

    @Test
    public void customErrorMapping() throws Exception {
        Object payload = this.flowRunner("mapping").run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)payload, (Matcher)Is.is((Object)"Mapped"));
    }

    @Test
    public void connectivityMapping() throws Exception {
        this.expectedError.expectErrorType("PETSTORE", "CONNECTIVITY");
        this.flowRunner("connectivity").run();
    }

    @Test
    public void exceptionInfo() throws Exception {
        Exception epe = this.flowRunner("withUnderlyingConnectorError").runExpectingException();
        Map info = ((MuleException)epe).getInfo();
        Assert.assertThat((Object)info.get("Element").toString(), (Matcher)Matchers.containsString((String)"withUnderlyingConnectorError/processors/0"));
    }
}

