/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.source;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.test.heisenberg.extension.AsyncHeisenbergSource;
import org.mule.test.module.extension.source.HeisenbergMessageSourceTestCase;

public class AsyncHeisenbergMessageSourceTestCase
extends HeisenbergMessageSourceTestCase {
    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        AsyncHeisenbergSource.completionCallback = null;
    }

    @Override
    protected void doTearDown() throws Exception {
        super.doTearDown();
        AsyncHeisenbergSource.completionCallback = null;
    }

    @Override
    protected String getConfigFile() {
        return "heisenberg-async-source-config.xml";
    }

    @Test
    public void asyncSource() throws Exception {
        this.startFlow("source");
        try {
            this.assertSourceCompleted();
            Assert.fail((String)"Source should not have completed");
        }
        catch (AssertionError e) {
            Assert.assertThat((Object)AsyncHeisenbergSource.completionCallback, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            AsyncHeisenbergSource.completionCallback.success();
            this.assertSourceCompleted();
        }
    }

    @Test
    public void asyncOnException() throws Exception {
        this.startFlow("sourceFailed");
        try {
            this.assertSourceFailed();
            Assert.fail((String)"Source should not have completed");
        }
        catch (AssertionError e) {
            Assert.assertThat((Object)AsyncHeisenbergSource.completionCallback, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            AsyncHeisenbergSource.completionCallback.error((Throwable)new Exception());
            this.assertSourceFailed();
        }
    }
}

