/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.values;

import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Test;
import org.mule.runtime.api.value.ResolvingFailure;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.api.value.ValueResult;
import org.mule.test.module.extension.values.AbstractValuesTestCase;

public class ConfigurationValuesTestCase
extends AbstractValuesTestCase {
    protected String getConfigFile() {
        return "values/configuration-values.xml";
    }

    @Test
    public void configWithValues() throws Exception {
        Set<Value> channels = this.getValuesFromConfig("config-with-value", "channel");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)3));
        MatcherAssert.assertThat(channels, this.hasValues("channel1", "channel2", "channel3"));
    }

    @Test
    public void configWithValuesWithRequiredParameters() throws Exception {
        Set<Value> channels = this.getValuesFromConfig("value-with-required-param", "channel");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)2));
        MatcherAssert.assertThat(channels, this.hasValues("required2:value2", "required1:value1"));
    }

    @Test
    public void configWithValuesWithRequiredParamsFromParamGroup() throws Exception {
        Set<Value> channels = this.getValuesFromConfig("values-with-required-params-from-param-group-config", "valueParam");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat(channels, this.hasValues("anyParameter:someValue"));
    }

    @Test
    public void configWithValuesWithRequiredParamsFromShowInDslGroup() throws Exception {
        Set<Value> channels = this.getValuesFromConfig("values-with-required-params-from-show-in-dsl-group", "valueParam");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat(channels, this.hasValues("anyParameter:someValue"));
    }

    @Test
    public void dynamicConfigWithValuesWithRequiredParamsFromShowInDslStaticGroup() throws Exception {
        Set<Value> channels = this.getValuesFromConfig("dynamic-config-values-with-required-params-from-show-in-dsl-static-group", "valueParam");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat(channels, this.hasValues("anyParameter:someValue"));
    }

    @Test
    public void dynamicConfigWithValuesWithRequiredParamsFromShowInDslDynamicGroup() throws Exception {
        Set<Value> channels = this.getValuesFromConfig("dynamic-config-values-with-required-params-from-show-in-dsl-dynamic-group", "valueParam");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat(channels, this.hasValues("anyParameter:someValue"));
    }

    @Test
    public void dynamicConfigWithValues() throws Exception {
        Set<Value> channels = this.getValuesFromConfig("dynamic-config", "channel");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)3));
        MatcherAssert.assertThat(channels, this.hasValues("channel1", "channel2", "channel3"));
    }

    @Test
    public void userErrorWhenResolvingValues() throws Exception {
        ValueResult result = this.getValueResultFromConfig("failure-config", "values");
        MatcherAssert.assertThat((Object)result.getFailure().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        ResolvingFailure resolvingFailure = (ResolvingFailure)result.getFailure().get();
        MatcherAssert.assertThat((Object)resolvingFailure.getFailureCode(), (Matcher)CoreMatchers.is((Object)"CUSTOM_ERROR"));
        MatcherAssert.assertThat((Object)resolvingFailure.getMessage(), (Matcher)CoreMatchers.is((Object)"Error!!!"));
    }

    @Test
    public void userErrorWhenResolvingValuesDynamic() throws Exception {
        ValueResult result = this.getValueResultFromConfig("dynamic-failure-config", "values");
        MatcherAssert.assertThat((Object)result.getFailure().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        ResolvingFailure resolvingFailure = (ResolvingFailure)result.getFailure().get();
        MatcherAssert.assertThat((Object)resolvingFailure.getFailureCode(), (Matcher)CoreMatchers.is((Object)"CUSTOM_ERROR"));
        MatcherAssert.assertThat((Object)resolvingFailure.getMessage(), (Matcher)CoreMatchers.is((Object)"Error!!!"));
    }
}

