/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl.resolver;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Date;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.DateTimeBuilder;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.module.extension.internal.config.dsl.resolver.ValueResolverFactoryTypeVisitor;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

public class ValueResolverFactoryTypeVisitorTestCase {
    private static final LocalDate LOCAL_DATE = LocalDate.parse("2021-04-28");
    private static final LocalDateTime LOCAL_DATE_TIME = LocalDateTime.parse("2021-04-28T14:30:35");
    private static final ZonedDateTime ZONED_DATE_TIME = ZonedDateTime.parse("2021-04-27T15:30:00Z");
    private DslSyntaxResolver dslSyntaxResolver;
    private ValueResolvingContext valueResolvingContext;

    @Before
    public void setup() {
        this.dslSyntaxResolver = (DslSyntaxResolver)Mockito.mock(DslSyntaxResolver.class);
        this.valueResolvingContext = (ValueResolvingContext)Mockito.mock(ValueResolvingContext.class);
    }

    @Test
    public void localDateValueIsResolved() throws MuleException {
        Class<LocalDate> theClass = LocalDate.class;
        ValueResolverFactoryTypeVisitor visitor = this.createValueResolverFactoryTypeVisitor("2021-04-28", theClass);
        visitor.visitDateTime(this.createDateTimeType(theClass));
        LocalDate localDate = (LocalDate)this.getVisitedValue(visitor);
        boolean isEqual = LOCAL_DATE.isEqual(localDate);
        MatcherAssert.assertThat((Object)isEqual, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void dateValueIsResolved() throws Exception {
        Class<Date> theClass = Date.class;
        ValueResolverFactoryTypeVisitor visitor = this.createValueResolverFactoryTypeVisitor("2021-04-28", theClass);
        visitor.visitDateTime(this.createDateTimeType(theClass));
        Date date = (Date)this.getVisitedValue(visitor);
        boolean isEqual = new SimpleDateFormat("yyyy-MM-dd").parse("2021-04-28").equals(date);
        MatcherAssert.assertThat((Object)isEqual, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void localDateTimeValueIsResolved() throws MuleException {
        Class<LocalDateTime> theClass = LocalDateTime.class;
        ValueResolverFactoryTypeVisitor visitor = this.createValueResolverFactoryTypeVisitor("2021-04-28T14:30:35", theClass);
        visitor.visitDateTime(this.createDateTimeType(theClass));
        LocalDateTime localDateTime = (LocalDateTime)this.getVisitedValue(visitor);
        boolean isEqual = LOCAL_DATE_TIME.isEqual(localDateTime);
        MatcherAssert.assertThat((Object)isEqual, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void zonedDateTimeValueIsResolved() throws MuleException {
        Class<ZonedDateTime> theClass = ZonedDateTime.class;
        ValueResolverFactoryTypeVisitor visitor = this.createValueResolverFactoryTypeVisitor("2021-04-27T15:30:00Z", theClass);
        visitor.visitDateTime(this.createDateTimeType(theClass));
        ZonedDateTime zonedDateTime = (ZonedDateTime)this.getVisitedValue(visitor);
        boolean isEqual = ZONED_DATE_TIME.isEqual(zonedDateTime);
        MatcherAssert.assertThat((Object)isEqual, (Matcher)Matchers.is((Object)true));
    }

    private ValueResolverFactoryTypeVisitor createValueResolverFactoryTypeVisitor(Object value, Class<?> expectedClass) {
        return new ValueResolverFactoryTypeVisitor(this.dslSyntaxResolver, "parameter", value, null, false, false, expectedClass);
    }

    private DateTimeType createDateTimeType(Class<?> expectedClass) {
        DateTimeBuilder builder = new BaseTypeBuilder(MetadataFormat.JAVA).dateTimeType().id(expectedClass.getCanonicalName());
        return builder.build();
    }

    private <T> T getVisitedValue(ValueResolverFactoryTypeVisitor visitor) throws MuleException {
        return (T)visitor.getResolver().resolve(this.valueResolvingContext);
    }
}

